/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.opendistro.elasticsearch.performanceanalyzer.decisionmaker.deciders.jvm.old_gen;

import com.amazon.opendistro.elasticsearch.performanceanalyzer.AppContext;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.decisionmaker.actions.Action;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.decisionmaker.actions.CacheClearAction;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.decisionmaker.actions.ModifyCacheMaxSizeAction;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.decisionmaker.actions.ModifyQueueCapacityAction;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.decisionmaker.actions.configs.CacheActionConfig;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.decisionmaker.actions.configs.QueueActionConfig;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.decisionmaker.deciders.configs.DeciderConfig;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.decisionmaker.deciders.configs.jvm.LevelThreeActionBuilderConfig;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.decisionmaker.deciders.configs.jvm.OldGenDecisionPolicyConfig;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.grpc.ResourceEnum;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.rca.framework.core.RcaConf;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.rca.store.rca.cluster.NodeKey;
import java.util.ArrayList;
import java.util.List;

public class LevelThreeActionBuilder {
    private final AppContext appContext;
    private final RcaConf rcaConf;
    private final NodeKey esNode;
    private final List<Action> actions;
    private final OldGenDecisionPolicyConfig oldGenDecisionPolicyConfig;
    private final LevelThreeActionBuilderConfig actionBuilderConfig;
    private final CacheActionConfig cacheActionConfig;
    private final QueueActionConfig queueActionConfig;

    private LevelThreeActionBuilder(NodeKey esNode, AppContext appContext, RcaConf rcaConf) {
        this.appContext = appContext;
        this.rcaConf = rcaConf;
        this.esNode = esNode;
        DeciderConfig deciderConfig = rcaConf.getDeciderConfig();
        this.oldGenDecisionPolicyConfig = rcaConf.getDeciderConfig().getOldGenDecisionPolicyConfig();
        this.actionBuilderConfig = deciderConfig.getOldGenDecisionPolicyConfig().levelThreeActionBuilderConfig();
        this.cacheActionConfig = rcaConf.getCacheActionConfig();
        this.queueActionConfig = rcaConf.getQueueActionConfig();
        this.actions = new ArrayList<Action>();
    }

    public static LevelThreeActionBuilder newBuilder(NodeKey esNode, AppContext appContext, RcaConf rcaConf) {
        return new LevelThreeActionBuilder(esNode, appContext, rcaConf);
    }

    public void addFieldDataCacheAction() {
        ModifyCacheMaxSizeAction action = ModifyCacheMaxSizeAction.newBuilder(this.esNode, ResourceEnum.FIELD_DATA_CACHE, this.appContext, this.rcaConf).increase(false).setDesiredCacheMaxSizeToMin().build();
        if (action.isActionable()) {
            this.actions.add(action);
        }
    }

    public void addShardRequestCacheAction() {
        ModifyCacheMaxSizeAction action = ModifyCacheMaxSizeAction.newBuilder(this.esNode, ResourceEnum.SHARD_REQUEST_CACHE, this.appContext, this.rcaConf).increase(false).setDesiredCacheMaxSizeToMin().build();
        if (action.isActionable()) {
            this.actions.add(action);
        }
    }

    private void addWriteQueueAction() {
        int stepSize = this.queueActionConfig.getStepSize(ResourceEnum.WRITE_THREADPOOL);
        ModifyQueueCapacityAction action = ModifyQueueCapacityAction.newBuilder(this.esNode, ResourceEnum.WRITE_THREADPOOL, this.appContext, this.rcaConf).increase(false).stepSize(stepSize * this.actionBuilderConfig.writeQueueStepSize()).build();
        if (action.isActionable()) {
            this.actions.add(action);
        }
    }

    private void addSearchQueueAction() {
        int stepSize = this.queueActionConfig.getStepSize(ResourceEnum.SEARCH_THREADPOOL);
        ModifyQueueCapacityAction action = ModifyQueueCapacityAction.newBuilder(this.esNode, ResourceEnum.SEARCH_THREADPOOL, this.appContext, this.rcaConf).increase(false).stepSize(stepSize * this.actionBuilderConfig.searchQueueStepSize()).build();
        if (action.isActionable()) {
            this.actions.add(action);
        }
    }

    private void addCacheClearAction() {
        CacheClearAction action = CacheClearAction.newBuilder(this.appContext).build();
        if (action.isActionable()) {
            this.actions.add(action);
        }
    }

    public List<Action> build() {
        this.addFieldDataCacheAction();
        this.addShardRequestCacheAction();
        this.addSearchQueueAction();
        this.addWriteQueueAction();
        this.addCacheClearAction();
        return this.actions;
    }
}

