/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.opendistro.elasticsearch.performanceanalyzer.decisionmaker.deciders.jvm.old_gen;

import com.amazon.opendistro.elasticsearch.performanceanalyzer.AppContext;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.decisionmaker.actions.Action;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.decisionmaker.actions.ModifyCacheMaxSizeAction;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.decisionmaker.actions.configs.CacheActionConfig;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.decisionmaker.deciders.configs.jvm.LevelOneActionBuilderConfig;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.decisionmaker.deciders.configs.jvm.OldGenDecisionPolicyConfig;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.grpc.ResourceEnum;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.rca.framework.core.RcaConf;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.rca.store.rca.cluster.NodeKey;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class LevelOneActionBuilder {
    private final AppContext appContext;
    private final RcaConf rcaConf;
    private final OldGenDecisionPolicyConfig oldGenDecisionPolicyConfig;
    private final LevelOneActionBuilderConfig actionBuilderConfig;
    private final CacheActionConfig cacheActionConfig;
    private final NodeKey esNode;
    private final Map<ResourceEnum, ModifyCacheMaxSizeAction> cacheActionMap;

    private LevelOneActionBuilder(NodeKey esNode, AppContext appContext, RcaConf rcaConf) {
        this.appContext = appContext;
        this.rcaConf = rcaConf;
        this.oldGenDecisionPolicyConfig = rcaConf.getDeciderConfig().getOldGenDecisionPolicyConfig();
        this.actionBuilderConfig = this.oldGenDecisionPolicyConfig.levelOneActionBuilderConfig();
        this.cacheActionConfig = rcaConf.getCacheActionConfig();
        this.esNode = esNode;
        this.cacheActionMap = new HashMap<ResourceEnum, ModifyCacheMaxSizeAction>();
        this.registerActions();
    }

    public static LevelOneActionBuilder newBuilder(NodeKey esNode, AppContext appContext, RcaConf rcaConf) {
        return new LevelOneActionBuilder(esNode, appContext, rcaConf);
    }

    private void addFieldDataCacheAction() {
        double stepSizeInPercent = this.cacheActionConfig.getStepSize(ResourceEnum.FIELD_DATA_CACHE);
        ModifyCacheMaxSizeAction action = ModifyCacheMaxSizeAction.newBuilder(this.esNode, ResourceEnum.FIELD_DATA_CACHE, this.appContext, this.rcaConf).increase(false).stepSizeInPercent(stepSizeInPercent * (double)this.actionBuilderConfig.fieldDataCacheStepSize()).build();
        if (action.isActionable()) {
            this.cacheActionMap.put(ResourceEnum.FIELD_DATA_CACHE, action);
        }
    }

    private void addShardRequestCacheAction() {
        double stepSizeInPercent = this.cacheActionConfig.getStepSize(ResourceEnum.SHARD_REQUEST_CACHE);
        ModifyCacheMaxSizeAction action = ModifyCacheMaxSizeAction.newBuilder(this.esNode, ResourceEnum.SHARD_REQUEST_CACHE, this.appContext, this.rcaConf).increase(false).stepSizeInPercent(stepSizeInPercent * (double)this.actionBuilderConfig.shardRequestCacheStepSize()).build();
        if (action.isActionable()) {
            this.cacheActionMap.put(ResourceEnum.SHARD_REQUEST_CACHE, action);
        }
    }

    private void registerActions() {
        this.addFieldDataCacheAction();
        this.addShardRequestCacheAction();
    }

    public List<Action> build() {
        ArrayList<Action> actions = new ArrayList<Action>();
        this.cacheActionMap.forEach((cache, action) -> actions.add((Action)action));
        return actions;
    }
}

