/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.opendistro.elasticsearch.performanceanalyzer.decisionmaker.deciders.jvm;

import com.amazon.opendistro.elasticsearch.performanceanalyzer.AppContext;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.decisionmaker.actions.Action;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.decisionmaker.actions.JvmGenAction;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.decisionmaker.deciders.DecisionPolicy;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.decisionmaker.deciders.configs.jvm.young_gen.JvmGenTuningPolicyConfig;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.decisionmaker.deciders.jvm.JvmActionsAlarmMonitor;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.grpc.Resource;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.rca.framework.api.aggregators.BucketizedSlidingWindowConfig;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.rca.framework.api.flow_units.ResourceFlowUnit;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.rca.framework.api.summaries.HotClusterSummary;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.rca.framework.api.summaries.HotNodeSummary;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.rca.framework.api.summaries.HotResourceSummary;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.rca.framework.api.summaries.ResourceUtil;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.rca.framework.core.RcaConf;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.rca.framework.util.RcaConsts;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.rca.store.collector.NodeConfigCache;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.rca.store.rca.HighHeapUsageClusterRca;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.rca.store.rca.cluster.NodeKey;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class JvmGenTuningPolicy
implements DecisionPolicy {
    private static final Logger LOG = LogManager.getLogger(JvmGenTuningPolicy.class);
    private static final long COOLOFF_PERIOD_IN_MILLIS = 172800000L;
    private static final Path UNDERSIZED_DATA_FILE_PATH = Paths.get(RcaConsts.CONFIG_DIR_PATH, "JvmGenerationTuningPolicy_Undersized");
    private static final Path OVERSIZED_DATA_FILE_PATH = Paths.get(RcaConsts.CONFIG_DIR_PATH, "JvmGenerationTuningPolicy_Oversized");
    static final List<Resource> YOUNG_GEN_UNDERSIZED_SIGNALS = Lists.newArrayList((Object[])new Resource[]{ResourceUtil.YOUNG_GEN_PROMOTION_RATE, ResourceUtil.FULL_GC_PAUSE_TIME});
    static final List<Resource> YOUNG_GEN_OVERSIZED_SIGNALS = Lists.newArrayList((Object[])new Resource[]{ResourceUtil.MINOR_GC_PAUSE_TIME, ResourceUtil.OLD_GEN_HEAP_USAGE});
    private AppContext appContext;
    private RcaConf rcaConf;
    private JvmGenTuningPolicyConfig policyConfig;
    private HighHeapUsageClusterRca highHeapUsageClusterRca;
    @VisibleForTesting
    JvmActionsAlarmMonitor tooSmallAlarm;
    @VisibleForTesting
    JvmActionsAlarmMonitor tooLargeAlarm;

    public JvmGenTuningPolicy(HighHeapUsageClusterRca highHeapUsageClusterRca) {
        this(highHeapUsageClusterRca, null, null);
    }

    public JvmGenTuningPolicy(HighHeapUsageClusterRca highHeapUsageClusterRca, JvmActionsAlarmMonitor tooSmallAlarm, JvmActionsAlarmMonitor tooLargeAlarm) {
        this.highHeapUsageClusterRca = highHeapUsageClusterRca;
        this.tooSmallAlarm = tooSmallAlarm;
        this.tooLargeAlarm = tooLargeAlarm;
    }

    private void record(HotResourceSummary issue) {
        LOG.debug("JVMGenTuningPolicy#record()");
        if (YOUNG_GEN_OVERSIZED_SIGNALS.contains(issue.getResource())) {
            LOG.debug("Recording issue in tooLargeAlarm");
            this.tooLargeAlarm.recordIssue();
        } else if (YOUNG_GEN_UNDERSIZED_SIGNALS.contains(issue.getResource())) {
            LOG.debug("Recording issue in tooSmallAlarm");
            this.tooSmallAlarm.recordIssue();
        }
    }

    private void recordIssues() {
        if (this.highHeapUsageClusterRca.getFlowUnits().isEmpty()) {
            return;
        }
        for (ResourceFlowUnit flowUnit : this.highHeapUsageClusterRca.getFlowUnits()) {
            if (!flowUnit.hasResourceSummary()) continue;
            HotClusterSummary clusterSummary = (HotClusterSummary)flowUnit.getSummary();
            for (HotNodeSummary nodeSummary : clusterSummary.getHotNodeSummaryList()) {
                for (HotResourceSummary summary : nodeSummary.getHotResourceSummaryList()) {
                    this.record(summary);
                }
            }
        }
    }

    public double getCurrentRatio() {
        LOG.debug("Computing current ratio...");
        if (this.appContext == null) {
            LOG.debug("JvmGenTuningPolicy AppContext is null");
            return -1.0;
        }
        NodeConfigCache cache = this.appContext.getNodeConfigCache();
        NodeKey key = new NodeKey(this.appContext.getDataNodeInstances().get(0));
        try {
            Double oldGenMaxSizeInBytes = cache.get(key, ResourceUtil.OLD_GEN_MAX_SIZE);
            LOG.debug("old gen max size is {}", (Object)oldGenMaxSizeInBytes);
            Double youngGenMaxSizeInBytes = cache.get(key, ResourceUtil.YOUNG_GEN_MAX_SIZE);
            LOG.debug("young gen max size is {}", (Object)youngGenMaxSizeInBytes);
            LOG.debug("current ratio is {}", (Object)(oldGenMaxSizeInBytes / youngGenMaxSizeInBytes));
            return oldGenMaxSizeInBytes / youngGenMaxSizeInBytes;
        }
        catch (IllegalArgumentException | NullPointerException e) {
            LOG.error("Exception while computing old:young generation sizing ratio", (Throwable)e);
            return -1.0;
        }
    }

    public int computeDecrease(double currentRatio) {
        if (currentRatio < 0.0 || currentRatio > 5.0) {
            return -1;
        }
        return (int)Math.floor(currentRatio + 1.0);
    }

    public int computeIncrease(double currentRatio) {
        if (currentRatio < 3.0) {
            return -1;
        }
        double newRatio = currentRatio > 5.0 ? 3.0 : currentRatio - 1.0;
        return (int)Math.floor(newRatio);
    }

    public boolean youngGenerationIsTooSmall() {
        return !this.tooSmallAlarm.isHealthy();
    }

    public boolean youngGenerationIsTooLarge() {
        return !this.tooLargeAlarm.isHealthy();
    }

    public JvmActionsAlarmMonitor createAlarmMonitor(Path persistenceBasePath) {
        BucketizedSlidingWindowConfig dayMonitorConfig = new BucketizedSlidingWindowConfig(this.policyConfig.getDayMonitorWindowSizeMinutes(), this.policyConfig.getDayMonitorBucketSizeMinutes(), TimeUnit.MINUTES, persistenceBasePath);
        BucketizedSlidingWindowConfig weekMonitorConfig = new BucketizedSlidingWindowConfig(this.policyConfig.getWeekMonitorWindowSizeMinutes(), this.policyConfig.getWeekMonitorBucketSizeMinutes(), TimeUnit.MINUTES, persistenceBasePath);
        return new JvmActionsAlarmMonitor(this.policyConfig.getDayBreachThreshold(), this.policyConfig.getWeekBreachThreshold(), UNDERSIZED_DATA_FILE_PATH, dayMonitorConfig, weekMonitorConfig);
    }

    public void initialize() {
        LOG.debug("Initializing alarms...");
        if (this.tooSmallAlarm == null) {
            this.tooSmallAlarm = this.createAlarmMonitor(UNDERSIZED_DATA_FILE_PATH);
        }
        if (this.tooLargeAlarm == null) {
            this.tooLargeAlarm = this.createAlarmMonitor(OVERSIZED_DATA_FILE_PATH);
        }
    }

    @Override
    public List<Action> evaluate() {
        LOG.debug("Evaluating JvmGenTuningPolicy...");
        ArrayList<Action> actions = new ArrayList<Action>();
        if (this.rcaConf == null || this.appContext == null) {
            LOG.error("rca conf/app context is null, return empty action list");
            return actions;
        }
        this.policyConfig = this.rcaConf.getDeciderConfig().getJvmGenTuningPolicyConfig();
        if (!this.policyConfig.isEnabled()) {
            LOG.debug("JvmGenerationTuningPolicy is disabled");
            return actions;
        }
        this.initialize();
        LOG.debug("Day breach threshold is {} and week breach threashold is {}", (Object)this.tooSmallAlarm.getDayBreachThreshold(), (Object)this.tooSmallAlarm.getWeekBreachThreshold());
        this.recordIssues();
        if (this.youngGenerationIsTooLarge()) {
            int newRatio;
            LOG.debug("The young generation is too large!");
            if (this.policyConfig.allowYoungGenDownsize() && (newRatio = this.computeDecrease(this.getCurrentRatio())) >= 1) {
                actions.add(new JvmGenAction(this.appContext, newRatio, 172800000L, true));
            }
        } else if (this.youngGenerationIsTooSmall()) {
            LOG.debug("The young generation is too small!");
            int newRatio = this.computeIncrease(this.getCurrentRatio());
            if (newRatio >= 1) {
                LOG.debug("Adding new JvmGenAction with ratio {}", (Object)newRatio);
                actions.add(new JvmGenAction(this.appContext, newRatio, 172800000L, true));
            }
        }
        return actions;
    }

    public void setAppContext(AppContext appContext) {
        this.appContext = appContext;
    }

    public void setRcaConf(RcaConf rcaConf) {
        this.rcaConf = rcaConf;
    }
}

