/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.opendistro.elasticsearch.performanceanalyzer.decisionmaker.deciders.jvm;

import com.amazon.opendistro.elasticsearch.performanceanalyzer.decisionmaker.deciders.AlarmMonitor;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.rca.framework.api.aggregators.BucketizedSlidingWindow;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.rca.framework.api.aggregators.BucketizedSlidingWindowConfig;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.rca.framework.api.aggregators.SlidingWindowData;
import com.google.common.annotations.VisibleForTesting;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;

public class JvmActionsAlarmMonitor
implements AlarmMonitor {
    private static final int DEFAULT_DAY_BREACH_THRESHOLD = 5;
    private static final int DEFAULT_WEEK_BREACH_THRESHOLD = 2;
    private static final String DAY_PREFIX = "day-";
    private static final String WEEK_PREFIX = "week-";
    public static final int DAY_MONITOR_BUCKET_WINDOW_MINUTES = 30;
    public static final int WEEK_MONITOR_BUCKET_WINDOW_MINUTES = 86400;
    private BucketizedSlidingWindow dayMonitor;
    private BucketizedSlidingWindow weekMonitor;
    private int dayBreachThreshold;
    private int weekBreachThreshold;
    private boolean alarmHealthy = true;

    public JvmActionsAlarmMonitor(int dayBreachThreshold, int weekBreachThreshold, @Nullable Path persistencePath, @Nullable BucketizedSlidingWindowConfig dayMonitorConfig, @Nullable BucketizedSlidingWindowConfig weekMonitorConfig) {
        Path dayMonitorPath = null;
        Path weekMonitorPath = null;
        if (persistencePath != null) {
            Path persistenceBase = persistencePath.getParent();
            Path persistenceFile = persistencePath.getFileName();
            if (persistenceBase != null && persistenceFile != null) {
                dayMonitorPath = Paths.get(persistenceBase.toString(), DAY_PREFIX + persistenceFile.toString());
                weekMonitorPath = Paths.get(persistenceBase.toString(), WEEK_PREFIX + persistenceFile.toString());
            }
        }
        this.dayMonitor = dayMonitorConfig == null ? new BucketizedSlidingWindow((int)TimeUnit.DAYS.toMinutes(1L), 30, TimeUnit.MINUTES, dayMonitorPath) : new BucketizedSlidingWindow(dayMonitorConfig);
        this.weekMonitor = weekMonitorConfig == null ? new BucketizedSlidingWindow(4, 1, TimeUnit.DAYS, weekMonitorPath) : new BucketizedSlidingWindow(weekMonitorConfig);
        this.dayBreachThreshold = dayBreachThreshold;
        this.weekBreachThreshold = weekBreachThreshold;
    }

    public JvmActionsAlarmMonitor(int dayBreachThreshold, int weekBreachThreshold, @Nullable Path persistencePath) {
        this(dayBreachThreshold, weekBreachThreshold, persistencePath, null, null);
    }

    public JvmActionsAlarmMonitor(int dayBreachThreshold, int weekBreachThreshold) {
        this(dayBreachThreshold, weekBreachThreshold, null, null, null);
    }

    public JvmActionsAlarmMonitor(@Nullable Path persistencePath) {
        this(5, 2, persistencePath);
    }

    public JvmActionsAlarmMonitor() {
        this(5, 2);
    }

    @Override
    public void recordIssue(long timeStamp, double value) {
        SlidingWindowData dataPoint = new SlidingWindowData(timeStamp, value);
        this.dayMonitor.next(dataPoint);
        if (this.dayMonitor.size() >= this.dayBreachThreshold) {
            this.weekMonitor.next(new SlidingWindowData(dataPoint.getTimeStamp(), dataPoint.getValue()));
        }
    }

    private void evaluateAlarm() {
        if (this.alarmHealthy) {
            if (this.weekMonitor.size() >= this.weekBreachThreshold) {
                this.alarmHealthy = false;
            }
        } else if (this.dayMonitor.size() == 0 && this.weekMonitor.size() == 0) {
            this.alarmHealthy = true;
        }
    }

    @Override
    public boolean isHealthy() {
        this.evaluateAlarm();
        return this.alarmHealthy;
    }

    public int getDayBreachThreshold() {
        return this.dayBreachThreshold;
    }

    public int getWeekBreachThreshold() {
        return this.weekBreachThreshold;
    }

    @VisibleForTesting
    BucketizedSlidingWindow getDayMonitor() {
        return this.dayMonitor;
    }

    @VisibleForTesting
    BucketizedSlidingWindow getWeekMonitor() {
        return this.weekMonitor;
    }

    @VisibleForTesting
    void setAlarmHealth(boolean isHealthy) {
        this.alarmHealthy = isHealthy;
    }
}

