/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.opendistro.elasticsearch.performanceanalyzer.decisionmaker.deciders.jvm;

import com.amazon.opendistro.elasticsearch.performanceanalyzer.AppContext;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.decisionmaker.actions.Action;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.decisionmaker.deciders.Decider;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.decisionmaker.deciders.Decision;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.decisionmaker.deciders.jvm.JvmGenTuningPolicy;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.decisionmaker.deciders.jvm.old_gen.OldGenDecisionPolicy;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.decisionmaker.deciders.jvm.sizing.HeapSizeIncreasePolicy;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.rca.framework.core.RcaConf;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.rca.store.rca.HighHeapUsageClusterRca;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.rca.store.rca.jvmsizing.LargeHeapClusterRca;
import java.util.List;

public class HeapHealthDecider
extends Decider {
    private static final int EVAL_INTERVAL_IN_S = 5;
    public static final String NAME = "HeapHealthDecider";
    private final OldGenDecisionPolicy oldGenDecisionPolicy;
    private final JvmGenTuningPolicy jvmGenTuningPolicy;
    private final HeapSizeIncreasePolicy heapSizeIncreasePolicy;
    private int counter = 0;

    public HeapHealthDecider(int decisionFrequency, HighHeapUsageClusterRca highHeapUsageClusterRca, LargeHeapClusterRca largeHeapClusterRca) {
        super(5L, decisionFrequency);
        this.oldGenDecisionPolicy = new OldGenDecisionPolicy(highHeapUsageClusterRca);
        this.jvmGenTuningPolicy = new JvmGenTuningPolicy(highHeapUsageClusterRca);
        this.heapSizeIncreasePolicy = new HeapSizeIncreasePolicy(largeHeapClusterRca);
    }

    @Override
    public String name() {
        return NAME;
    }

    @Override
    public Decision operate() {
        Decision decision = new Decision(System.currentTimeMillis(), NAME);
        ++this.counter;
        if (this.counter < this.decisionFrequency) {
            return decision;
        }
        this.counter = 0;
        List<Action> oldGenPolicyActions = this.oldGenDecisionPolicy.evaluate();
        oldGenPolicyActions.forEach(decision::addAction);
        List<Action> jvmScaleUpActions = this.heapSizeIncreasePolicy.evaluate();
        jvmScaleUpActions.forEach(decision::addAction);
        if (jvmScaleUpActions == null || jvmScaleUpActions.isEmpty()) {
            List<Action> jvmGenTuningActions = this.jvmGenTuningPolicy.evaluate();
            jvmGenTuningActions.forEach(decision::addAction);
        }
        return decision;
    }

    @Override
    public void readRcaConf(RcaConf conf) {
        super.readRcaConf(conf);
        this.oldGenDecisionPolicy.setRcaConf(conf);
        this.jvmGenTuningPolicy.setRcaConf(conf);
        this.heapSizeIncreasePolicy.setRcaConf(conf);
    }

    @Override
    public void setAppContext(AppContext appContext) {
        super.setAppContext(appContext);
        this.oldGenDecisionPolicy.setAppContext(appContext);
        this.jvmGenTuningPolicy.setAppContext(appContext);
        this.heapSizeIncreasePolicy.setAppContext(appContext);
    }
}

