/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.opendistro.elasticsearch.performanceanalyzer.decisionmaker.deciders.configs.jvm.young_gen;

import com.amazon.opendistro.elasticsearch.performanceanalyzer.rca.framework.core.Config;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.rca.framework.core.NestedConfig;
import java.util.concurrent.TimeUnit;

public class JvmGenTuningPolicyConfig {
    private static final String ENABLED = "enabled";
    private static final String ALLOW_YOUNG_GEN_DOWNSIZE = "allow-young-gen-downsize";
    private static final String DAY_BREACH_THRESHOLD = "day-breach-threshold";
    private static final String WEEK_BREACH_THRESHOLD = "week-breach-threshold";
    private static final String DAY_MONITOR_WINDOW_SIZE_MINUTES = "day-monitor-window-size-minutes";
    private static final String WEEK_MONITOR_WINDOW_SIZE_MINUTES = "week-monitor-window-size-minutes";
    private static final String DAY_MONITOR_BUCKET_SIZE_MINUTES = "day-monitor-bucket-size-minutes";
    private static final String WEEK_MONITOR_BUCKET_SIZE_MINUTES = "week-monitor-bucket-size-minutes";
    public static final boolean DEFAULT_ENABLED = true;
    public static final boolean DEFAULT_ALLOW_YOUNG_GEN_DOWNSIZE = false;
    public static final int DEFAULT_DAY_BREACH_THRESHOLD = 5;
    public static final int DEFAULT_WEEK_BREACH_THRESHOLD = 2;
    public static final int DEFAULT_DAY_MONITOR_WINDOW_SIZE_MINUTES = (int)TimeUnit.DAYS.toMinutes(1L);
    public static final int DEFAULT_WEEK_MONITOR_WINDOW_SIZE_MINUTES = (int)TimeUnit.DAYS.toMinutes(4L);
    public static final int DEFAULT_DAY_MONITOR_BUCKET_SIZE_MINUTES = 30;
    public static final int DEFAULT_WEEK_MONITOR_BUCKET_SIZE_MINUTES = (int)TimeUnit.DAYS.toMinutes(1L);
    private Config<Integer> dayBreachThreshold;
    private Config<Integer> weekBreachThreshold;
    private Config<Boolean> enabled;
    private Config<Boolean> allowYoungGenDownsize;
    private Config<Integer> dayMonitorWindowSizeMinutes;
    private Config<Integer> weekMonitorWindowSizeMinutes;
    private Config<Integer> dayMonitorBucketSizeMinutes;
    private Config<Integer> weekMonitorBucketSizeMinutes;

    public JvmGenTuningPolicyConfig(NestedConfig config) {
        this.enabled = new Config<Boolean>(ENABLED, config.getValue(), true, Boolean.class);
        this.allowYoungGenDownsize = new Config<Boolean>(ALLOW_YOUNG_GEN_DOWNSIZE, config.getValue(), false, Boolean.class);
        this.dayBreachThreshold = new Config<Integer>(DAY_BREACH_THRESHOLD, config.getValue(), 5, Integer.class);
        this.weekBreachThreshold = new Config<Integer>(WEEK_BREACH_THRESHOLD, config.getValue(), 2, Integer.class);
        this.dayMonitorWindowSizeMinutes = new Config<Integer>(DAY_MONITOR_WINDOW_SIZE_MINUTES, config.getValue(), DEFAULT_DAY_MONITOR_WINDOW_SIZE_MINUTES, Integer.class);
        this.weekMonitorWindowSizeMinutes = new Config<Integer>(WEEK_MONITOR_WINDOW_SIZE_MINUTES, config.getValue(), DEFAULT_WEEK_MONITOR_WINDOW_SIZE_MINUTES, Integer.class);
        this.dayMonitorBucketSizeMinutes = new Config<Integer>(DAY_MONITOR_BUCKET_SIZE_MINUTES, config.getValue(), 30, Integer.class);
        this.weekMonitorBucketSizeMinutes = new Config<Integer>(WEEK_MONITOR_BUCKET_SIZE_MINUTES, config.getValue(), DEFAULT_WEEK_MONITOR_BUCKET_SIZE_MINUTES, Integer.class);
    }

    public boolean isEnabled() {
        return this.enabled.getValue();
    }

    public boolean allowYoungGenDownsize() {
        return this.allowYoungGenDownsize.getValue();
    }

    public int getDayBreachThreshold() {
        return this.dayBreachThreshold.getValue();
    }

    public int getWeekBreachThreshold() {
        return this.weekBreachThreshold.getValue();
    }

    public int getDayMonitorWindowSizeMinutes() {
        return this.dayMonitorWindowSizeMinutes.getValue();
    }

    public int getWeekMonitorWindowSizeMinutes() {
        return this.weekMonitorWindowSizeMinutes.getValue();
    }

    public int getDayMonitorBucketSizeMinutes() {
        return this.dayMonitorBucketSizeMinutes.getValue();
    }

    public int getWeekMonitorBucketSizeMinutes() {
        return this.weekMonitorBucketSizeMinutes.getValue();
    }
}

