/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.opendistro.elasticsearch.performanceanalyzer.decisionmaker.deciders.configs.jvm;

import com.amazon.opendistro.elasticsearch.performanceanalyzer.rca.framework.core.Config;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.rca.framework.core.NestedConfig;

public class LevelTwoActionBuilderConfig {
    public static final int DEFAULT_FIELD_DATA_CACHE_STEP_SIZE = 2;
    public static final int DEFAULT_SHARD_REQUEST_CACHE_STEP_SIZE = 2;
    public static final int DEFAULT_WRITE_QUEUE_STEP_SIZE = 1;
    public static final int DEFAULT_SEARCH_QUEUE_STEP_SIZE = 1;
    private static final String FIELD_DATA_CACHE_STEP_SIZE_CONFIG_NAME = "fielddata-cache-step-size";
    private static final String SHARD_REQUEST_CACHE_STEP_SIZE_CONFIG_NAME = "shard-request-cache-step-size";
    private static final String WRITE_QUEUE_STEP_SIZE_CONFIG_NAME = "write-queue-step-size";
    private static final String SEARCH_QUEUE_STEP_SIZE_CONFIG_NAME = "search-queue-step-size";
    private Config<Integer> fieldDataCacheStepSize;
    private Config<Integer> shardRequestCacheStepSize;
    private Config<Integer> writeQueueStepSize;
    private Config<Integer> searchQueueStepSize;

    public LevelTwoActionBuilderConfig(NestedConfig configs) {
        this.fieldDataCacheStepSize = new Config<Integer>(FIELD_DATA_CACHE_STEP_SIZE_CONFIG_NAME, configs.getValue(), 2, s -> s >= 0, Integer.class);
        this.shardRequestCacheStepSize = new Config<Integer>(SHARD_REQUEST_CACHE_STEP_SIZE_CONFIG_NAME, configs.getValue(), 2, s -> s >= 0, Integer.class);
        this.writeQueueStepSize = new Config<Integer>(WRITE_QUEUE_STEP_SIZE_CONFIG_NAME, configs.getValue(), 1, s -> s >= 0, Integer.class);
        this.searchQueueStepSize = new Config<Integer>(SEARCH_QUEUE_STEP_SIZE_CONFIG_NAME, configs.getValue(), 1, s -> s >= 0, Integer.class);
    }

    public int fieldDataCacheStepSize() {
        return this.fieldDataCacheStepSize.getValue();
    }

    public int shardRequestCacheStepSize() {
        return this.shardRequestCacheStepSize.getValue();
    }

    public int writeQueueStepSize() {
        return this.writeQueueStepSize.getValue();
    }

    public int searchQueueStepSize() {
        return this.searchQueueStepSize.getValue();
    }
}

