/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.opendistro.elasticsearch.performanceanalyzer.decisionmaker.deciders.configs;

import com.amazon.opendistro.elasticsearch.performanceanalyzer.decisionmaker.deciders.configs.CachePriorityOrderConfig;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.decisionmaker.deciders.configs.WorkLoadTypeConfig;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.decisionmaker.deciders.configs.jvm.OldGenDecisionPolicyConfig;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.decisionmaker.deciders.configs.jvm.young_gen.JvmGenTuningPolicyConfig;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.rca.framework.core.NestedConfig;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.rca.framework.core.RcaConf;

public class DeciderConfig {
    private static final String CACHE_CONFIG_NAME = "cache-type";
    private static final String WORKLOAD_CONFIG_NAME = "workload-type";
    private static final String OLD_GEN_DECISION_POLICY_CONFIG_NAME = "old-gen-decision-policy-config";
    private static final String JVM_GEN_TUNING_POLICY_CONFIG_NAME = "jvm-gen-tuning-policy-config";
    private final CachePriorityOrderConfig cachePriorityOrderConfig;
    private final WorkLoadTypeConfig workLoadTypeConfig;
    private final OldGenDecisionPolicyConfig oldGenDecisionPolicyConfig;
    private final JvmGenTuningPolicyConfig jvmGenTuningPolicyConfig;

    public DeciderConfig(RcaConf rcaConf) {
        this.cachePriorityOrderConfig = new CachePriorityOrderConfig(new NestedConfig(CACHE_CONFIG_NAME, rcaConf.getDeciderConfigSettings()));
        this.workLoadTypeConfig = new WorkLoadTypeConfig(new NestedConfig(WORKLOAD_CONFIG_NAME, rcaConf.getDeciderConfigSettings()));
        this.oldGenDecisionPolicyConfig = new OldGenDecisionPolicyConfig(new NestedConfig(OLD_GEN_DECISION_POLICY_CONFIG_NAME, rcaConf.getDeciderConfigSettings()));
        this.jvmGenTuningPolicyConfig = new JvmGenTuningPolicyConfig(new NestedConfig(JVM_GEN_TUNING_POLICY_CONFIG_NAME, rcaConf.getDeciderConfigSettings()));
    }

    public CachePriorityOrderConfig getCachePriorityOrderConfig() {
        return this.cachePriorityOrderConfig;
    }

    public WorkLoadTypeConfig getWorkLoadTypeConfig() {
        return this.workLoadTypeConfig;
    }

    public OldGenDecisionPolicyConfig getOldGenDecisionPolicyConfig() {
        return this.oldGenDecisionPolicyConfig;
    }

    public JvmGenTuningPolicyConfig getJvmGenTuningPolicyConfig() {
        return this.jvmGenTuningPolicyConfig;
    }
}

