/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.opendistro.elasticsearch.performanceanalyzer.decisionmaker.deciders.collator;

import com.amazon.opendistro.elasticsearch.performanceanalyzer.decisionmaker.actions.Action;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.decisionmaker.actions.ImpactVector;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.decisionmaker.deciders.collator.ImpactAssessment;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.rca.store.rca.cluster.NodeKey;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.checkerframework.checker.nullness.qual.NonNull;

public class ImpactAssessor {
    private static final Logger LOG = LogManager.getLogger(ImpactAssessor.class);

    public @NonNull Map<NodeKey, ImpactAssessment> assessOverallImpact(@NonNull List<Action> actions) {
        HashMap<NodeKey, ImpactAssessment> overallImpactAssessment = new HashMap<NodeKey, ImpactAssessment>();
        actions.forEach(action -> {
            Map<NodeKey, ImpactVector> impactMap = action.impact();
            impactMap.forEach((nodeKey, impactVector) -> overallImpactAssessment.computeIfAbsent((NodeKey)nodeKey, ImpactAssessment::new).addActionImpact(action.name(), (ImpactVector)impactVector));
        });
        return overallImpactAssessment;
    }

    public boolean isImpactAligned(@NonNull Action action, @NonNull Map<NodeKey, ImpactAssessment> overallImpactAssessment) {
        boolean isAligned = true;
        for (NodeKey nodeKey : action.impactedNodes()) {
            if (!overallImpactAssessment.containsKey(nodeKey)) {
                LOG.error("Overall impact assessment does not a node key: {} for which an impacting action exists.", (Object)nodeKey);
                return false;
            }
            ImpactAssessment nodeImpactAssessment = overallImpactAssessment.get(nodeKey);
            isAligned = isAligned && nodeImpactAssessment.checkAlignmentAcrossDimensions(action.name(), action.impact().get(nodeKey));
        }
        return isAligned;
    }

    public void undoActionImpactOnOverallAssessment(@NonNull Action action, @NonNull Map<NodeKey, ImpactAssessment> overallImpactAssessment) {
        for (NodeKey nodeKey : action.impactedNodes()) {
            if (!overallImpactAssessment.containsKey(nodeKey)) {
                LOG.error("Overall impact assessment does not a node key: {} for which an impacting action exists.", (Object)nodeKey);
                return;
            }
            ImpactAssessment nodeImpactAssessment = overallImpactAssessment.get(nodeKey);
            nodeImpactAssessment.removeActionImpact(action.name(), action.impact().get(nodeKey));
        }
    }
}

