/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.opendistro.elasticsearch.performanceanalyzer.decisionmaker.deciders;

import com.amazon.opendistro.elasticsearch.performanceanalyzer.PerformanceAnalyzerApp;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.decisionmaker.actions.Action;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.decisionmaker.actions.ModifyQueueCapacityAction;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.decisionmaker.deciders.Decider;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.decisionmaker.deciders.Decision;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.decisionmaker.deciders.HeapBasedDecider;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.grpc.ResourceEnum;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.rca.framework.api.flow_units.ResourceFlowUnit;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.rca.framework.api.summaries.HotClusterSummary;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.rca.framework.api.summaries.HotNodeSummary;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.rca.framework.api.summaries.HotResourceSummary;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.rca.framework.metrics.RcaRuntimeMetrics;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.rca.store.rca.HighHeapUsageClusterRca;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.rca.store.rca.cluster.NodeKey;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.rca.store.rca.cluster.QueueRejectionClusterRca;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class QueueHealthDecider
extends HeapBasedDecider {
    private static final Logger LOG = LogManager.getLogger(Decider.class);
    public static final String NAME = "queue_health";
    private QueueRejectionClusterRca queueRejectionRca;
    List<String> actionsByUserPriority = new ArrayList<String>();
    private int counter = 0;

    public QueueHealthDecider(long evalIntervalSeconds, int decisionFrequency, QueueRejectionClusterRca queueRejectionClusterRca, HighHeapUsageClusterRca highHeapUsageClusterRca) {
        super(evalIntervalSeconds, decisionFrequency, highHeapUsageClusterRca);
        this.queueRejectionRca = queueRejectionClusterRca;
        this.configureActionPriority();
    }

    @Override
    public String name() {
        return NAME;
    }

    @Override
    public Decision operate() {
        Decision decision = new Decision(System.currentTimeMillis(), NAME);
        ++this.counter;
        if (this.counter < this.decisionFrequency) {
            return decision;
        }
        this.counter = 0;
        if (this.queueRejectionRca.getFlowUnits().isEmpty()) {
            return decision;
        }
        ResourceFlowUnit flowUnit = (ResourceFlowUnit)this.queueRejectionRca.getFlowUnits().get(0);
        if (!flowUnit.hasResourceSummary()) {
            return decision;
        }
        HotClusterSummary clusterSummary = (HotClusterSummary)flowUnit.getSummary();
        for (HotNodeSummary nodeSummary : clusterSummary.getHotNodeSummaryList()) {
            NodeKey esNode = new NodeKey(nodeSummary.getNodeID(), nodeSummary.getHostAddress());
            for (HotResourceSummary resource : nodeSummary.getHotResourceSummaryList()) {
                decision.addAction(this.computeBestAction(esNode, resource.getResource().getResourceEnum()));
            }
        }
        return decision;
    }

    private void configureActionPriority() {
        this.actionsByUserPriority.add("ModifyQueueCapacity");
    }

    private Action computeBestAction(NodeKey esNode, ResourceEnum threadPool) {
        Action action = null;
        if (this.canUseMoreHeap(esNode)) {
            String actionName;
            Iterator<String> iterator = this.actionsByUserPriority.iterator();
            while (iterator.hasNext() && (action = this.getAction(actionName = iterator.next(), esNode, threadPool, true)) == null) {
            }
        } else {
            PerformanceAnalyzerApp.RCA_RUNTIME_METRICS_AGGREGATOR.updateStat(RcaRuntimeMetrics.NO_INCREASE_ACTION_SUGGESTED, "queue_health:" + esNode.getHostAddress(), 1);
        }
        return action;
    }

    private Action getAction(String actionName, NodeKey esNode, ResourceEnum threadPool, boolean increase) {
        switch (actionName) {
            case "ModifyQueueCapacity": {
                return this.configureQueueCapacity(esNode, threadPool, increase);
            }
        }
        return null;
    }

    private ModifyQueueCapacityAction configureQueueCapacity(NodeKey esNode, ResourceEnum threadPool, boolean increase) {
        ModifyQueueCapacityAction action = ModifyQueueCapacityAction.newBuilder(esNode, threadPool, this.getAppContext(), this.rcaConf).increase(increase).build();
        if (action != null && action.isActionable()) {
            return action;
        }
        return null;
    }
}

