/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.opendistro.elasticsearch.performanceanalyzer.decisionmaker.deciders;

import com.amazon.opendistro.elasticsearch.performanceanalyzer.decisionmaker.deciders.Decider;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.grpc.Resource;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.grpc.ResourceEnum;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.rca.framework.api.flow_units.ResourceFlowUnit;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.rca.framework.api.summaries.HotClusterSummary;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.rca.framework.api.summaries.HotNodeSummary;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.rca.framework.api.summaries.HotResourceSummary;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.rca.framework.api.summaries.bucket.BasicBucketCalculator;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.rca.framework.api.summaries.bucket.BucketCalculator;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.rca.framework.api.summaries.bucket.UsageBucket;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.rca.store.rca.HighHeapUsageClusterRca;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.rca.store.rca.cluster.NodeKey;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class HeapBasedDecider
extends Decider {
    private static final Logger LOG = LogManager.getLogger(HeapBasedDecider.class);
    private static final String OLD_GEN_TUNABLE_KEY = "old-gen";
    private static final ResourceEnum DECIDING_HEAP_RESOURCE_TYPE = ResourceEnum.OLD_GEN;
    public static final ImmutableMap<UsageBucket, Double> DEFAULT_HEAP_USAGE_THRESHOLDS = ImmutableMap.builder().put((Object)UsageBucket.UNDER_UTILIZED, (Object)10.0).put((Object)UsageBucket.HEALTHY_WITH_BUFFER, (Object)60.0).put((Object)UsageBucket.HEALTHY, (Object)80.0).build();
    private HighHeapUsageClusterRca highHeapUsageClusterRca;

    public HeapBasedDecider(long evalIntervalSeconds, int decisionFrequency, HighHeapUsageClusterRca highHeapUsageClusterRca) {
        super(evalIntervalSeconds, decisionFrequency);
        this.highHeapUsageClusterRca = highHeapUsageClusterRca;
    }

    protected boolean canUseMoreHeap(NodeKey esNode) {
        for (ResourceFlowUnit clusterSummary : this.highHeapUsageClusterRca.getFlowUnits()) {
            if (!clusterSummary.hasResourceSummary()) continue;
            for (HotNodeSummary nodeSummary : ((HotClusterSummary)clusterSummary.getSummary()).getHotNodeSummaryList()) {
                NodeKey thisNode = new NodeKey(nodeSummary.getNodeID(), nodeSummary.getHostAddress());
                if (!thisNode.equals(esNode)) continue;
                for (HotResourceSummary hotResourceSummary : nodeSummary.getHotResourceSummaryList()) {
                    Resource resource = hotResourceSummary.getResource();
                    if (resource.getResourceEnum() != DECIDING_HEAP_RESOURCE_TYPE) continue;
                    return this.checkIfResourceCanBeTuned(hotResourceSummary.getValue());
                }
            }
        }
        return true;
    }

    private boolean checkIfResourceCanBeTuned(double oldGenUsedRatio) {
        BucketCalculator bucketCalculator;
        double oldGenUsedPercent = oldGenUsedRatio * 100.0;
        try {
            bucketCalculator = this.rcaConf.getBucketizationSettings(OLD_GEN_TUNABLE_KEY);
        }
        catch (Exception jsonEx) {
            bucketCalculator = new BasicBucketCalculator((Map<UsageBucket, Double>)DEFAULT_HEAP_USAGE_THRESHOLDS);
            LOG.debug("rca.conf does not have bucketization limits specified. Using default map.");
        }
        UsageBucket bucket = bucketCalculator.compute(oldGenUsedPercent);
        LOG.debug("Value ({}) bucketized to {}, using {}", (Object)oldGenUsedPercent, (Object)bucket.toString(), (Object)bucketCalculator.toString());
        boolean canTune = false;
        if (bucket == UsageBucket.UNDER_UTILIZED || bucket == UsageBucket.HEALTHY_WITH_BUFFER) {
            canTune = true;
        }
        return canTune;
    }
}

