/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.opendistro.elasticsearch.performanceanalyzer.decisionmaker.deciders;

import com.amazon.opendistro.elasticsearch.performanceanalyzer.PerformanceAnalyzerApp;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.decisionmaker.actions.Action;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.decisionmaker.actions.ModifyCacheMaxSizeAction;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.decisionmaker.deciders.Decision;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.decisionmaker.deciders.HeapBasedDecider;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.grpc.ResourceEnum;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.rca.framework.api.flow_units.ResourceFlowUnit;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.rca.framework.api.summaries.HotClusterSummary;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.rca.framework.api.summaries.HotNodeSummary;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.rca.framework.api.summaries.HotResourceSummary;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.rca.framework.metrics.RcaRuntimeMetrics;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.rca.framework.util.InstanceDetails;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.rca.store.rca.HighHeapUsageClusterRca;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.rca.store.rca.cluster.BaseClusterRca;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.rca.store.rca.cluster.FieldDataCacheClusterRca;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.rca.store.rca.cluster.NodeKey;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.rca.store.rca.cluster.ShardRequestCacheClusterRca;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CacheHealthDecider
extends HeapBasedDecider {
    private static final Logger LOG = LogManager.getLogger(CacheHealthDecider.class);
    public static final String NAME = "cacheHealthDecider";
    private final FieldDataCacheClusterRca fieldDataCacheClusterRca;
    private final ShardRequestCacheClusterRca shardRequestCacheClusterRca;
    private final ImmutableMap<ResourceEnum, BaseClusterRca> cacheTypeBaseClusterRcaMap;
    List<ResourceEnum> modifyCacheActionPriorityList = new ArrayList<ResourceEnum>();
    private int counter = 0;

    public CacheHealthDecider(long evalIntervalSeconds, int decisionFrequency, FieldDataCacheClusterRca fieldDataCacheClusterRca, ShardRequestCacheClusterRca shardRequestCacheClusterRca, HighHeapUsageClusterRca highHeapUsageClusterRca) {
        super(evalIntervalSeconds, decisionFrequency, highHeapUsageClusterRca);
        this.configureModifyCacheActionPriority();
        this.fieldDataCacheClusterRca = fieldDataCacheClusterRca;
        this.shardRequestCacheClusterRca = shardRequestCacheClusterRca;
        this.cacheTypeBaseClusterRcaMap = ImmutableMap.builder().put((Object)ResourceEnum.SHARD_REQUEST_CACHE, (Object)shardRequestCacheClusterRca).put((Object)ResourceEnum.FIELD_DATA_CACHE, (Object)fieldDataCacheClusterRca).build();
    }

    @Override
    public String name() {
        return NAME;
    }

    @Override
    public Decision operate() {
        HashSet<InstanceDetails.Id> impactedNodes = new HashSet<InstanceDetails.Id>();
        Decision decision = new Decision(System.currentTimeMillis(), NAME);
        ++this.counter;
        if (this.counter < this.decisionFrequency) {
            return decision;
        }
        this.counter = 0;
        for (ResourceEnum cacheType : this.modifyCacheActionPriorityList) {
            this.getActionsFromRca((BaseClusterRca)this.cacheTypeBaseClusterRcaMap.get((Object)cacheType), impactedNodes).forEach(decision::addAction);
        }
        return decision;
    }

    private <R extends BaseClusterRca> List<Action> getActionsFromRca(R cacheClusterRca, Set<InstanceDetails.Id> impactedNodes) {
        ArrayList<Action> actions = new ArrayList<Action>();
        if (!cacheClusterRca.getFlowUnits().isEmpty()) {
            ResourceFlowUnit flowUnit = (ResourceFlowUnit)cacheClusterRca.getFlowUnits().get(0);
            if (!flowUnit.hasResourceSummary()) {
                return actions;
            }
            List<HotNodeSummary> clusterSummary = ((HotClusterSummary)flowUnit.getSummary()).getHotNodeSummaryList();
            for (HotNodeSummary hotNodeSummary : clusterSummary) {
                if (impactedNodes.contains(hotNodeSummary.getNodeID())) continue;
                NodeKey esNode = new NodeKey(hotNodeSummary.getNodeID(), hotNodeSummary.getHostAddress());
                for (HotResourceSummary resource : hotNodeSummary.getHotResourceSummaryList()) {
                    Action action = this.computeBestAction(esNode, resource.getResource().getResourceEnum());
                    if (action == null) continue;
                    actions.add(action);
                    impactedNodes.add(hotNodeSummary.getNodeID());
                }
            }
        }
        return actions;
    }

    private void configureModifyCacheActionPriority() {
        this.modifyCacheActionPriorityList.add(ResourceEnum.SHARD_REQUEST_CACHE);
        this.modifyCacheActionPriorityList.add(ResourceEnum.FIELD_DATA_CACHE);
    }

    private Action computeBestAction(NodeKey esNode, ResourceEnum cacheType) {
        Action action = null;
        if (this.canUseMoreHeap(esNode)) {
            action = this.getAction("ModifyCacheMaxSize", esNode, cacheType, true);
        } else {
            PerformanceAnalyzerApp.RCA_RUNTIME_METRICS_AGGREGATOR.updateStat(RcaRuntimeMetrics.NO_INCREASE_ACTION_SUGGESTED, "cacheHealthDecider:" + esNode.getHostAddress(), 1);
        }
        return action;
    }

    private Action getAction(String actionName, NodeKey esNode, ResourceEnum cacheType, boolean increase) {
        if ("ModifyCacheMaxSize".equals(actionName)) {
            return this.configureCacheMaxSize(esNode, cacheType, increase);
        }
        return null;
    }

    private ModifyCacheMaxSizeAction configureCacheMaxSize(NodeKey esNode, ResourceEnum cacheType, boolean increase) {
        ModifyCacheMaxSizeAction action = ModifyCacheMaxSizeAction.newBuilder(esNode, cacheType, this.getAppContext(), this.rcaConf).increase(increase).build();
        if (action.isActionable()) {
            return action;
        }
        return null;
    }
}

