/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.opendistro.elasticsearch.performanceanalyzer.decisionmaker.actions;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class ImpactVector {
    private Map<Dimension, Impact> impactMap = new HashMap<Dimension, Impact>();

    public ImpactVector() {
        for (Dimension d : Dimension.values()) {
            this.impactMap.put(d, Impact.NO_IMPACT);
        }
    }

    public Map<Dimension, Impact> getImpact() {
        return Collections.unmodifiableMap(this.impactMap);
    }

    public void increasesPressure(Dimension ... dimensions) {
        for (Dimension dimension : dimensions) {
            this.impactMap.put(dimension, Impact.INCREASES_PRESSURE);
        }
    }

    public void decreasesPressure(Dimension ... dimensions) {
        for (Dimension dimension : dimensions) {
            this.impactMap.put(dimension, Impact.DECREASES_PRESSURE);
        }
    }

    public void noImpact(Dimension ... dimensions) {
        for (Dimension dimension : dimensions) {
            this.impactMap.put(dimension, Impact.NO_IMPACT);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ImpactVector that = (ImpactVector)o;
        return Objects.equals(this.impactMap, that.impactMap);
    }

    public int hashCode() {
        return Objects.hash(this.impactMap);
    }

    public static enum Impact {
        NO_IMPACT,
        INCREASES_PRESSURE,
        DECREASES_PRESSURE;

    }

    public static enum Dimension {
        HEAP,
        CPU,
        RAM,
        DISK,
        NETWORK;

    }
}

