/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.opendistro.elasticsearch.performanceanalyzer.decisionmaker.actions;

import com.amazon.opendistro.elasticsearch.performanceanalyzer.AppContext;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.decisionmaker.actions.ImpactVector;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.decisionmaker.actions.SuppressibleAction;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.rca.framework.util.InstanceDetails;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.rca.store.rca.cluster.NodeKey;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;

public class HeapSizeIncreaseAction
extends SuppressibleAction {
    public static final String NAME = "HeapSizeIncreaseAction";
    private static final String ID_KEY = "Id";
    private static final String IP_KEY = "Ip";
    private final NodeKey esNode;
    private static final long DEFAULT_COOL_OFF_PERIOD_IN_MILLIS = TimeUnit.DAYS.toMillis(3L);

    public HeapSizeIncreaseAction(@Nonnull AppContext appContext) {
        super(appContext);
        this.esNode = new NodeKey(appContext.getMyInstanceDetails());
    }

    public HeapSizeIncreaseAction(NodeKey nodeKey, AppContext appContext) {
        super(appContext);
        this.esNode = nodeKey;
    }

    @Override
    public boolean canUpdate() {
        return true;
    }

    @Override
    public long coolOffPeriodInMillis() {
        return DEFAULT_COOL_OFF_PERIOD_IN_MILLIS;
    }

    @Override
    public List<NodeKey> impactedNodes() {
        return this.appContext.getDataNodeInstances().stream().map(NodeKey::new).collect(Collectors.toList());
    }

    @Override
    public Map<NodeKey, ImpactVector> impact() {
        HashMap<NodeKey, ImpactVector> impactMap = new HashMap<NodeKey, ImpactVector>();
        for (NodeKey nodeKey : this.impactedNodes()) {
            ImpactVector impactVector = new ImpactVector();
            impactVector.decreasesPressure(ImpactVector.Dimension.HEAP);
            impactMap.put(nodeKey, impactVector);
        }
        return impactMap;
    }

    @Override
    public String name() {
        return NAME;
    }

    @Override
    public String summary() {
        JsonObject summaryJson = new JsonObject();
        summaryJson.addProperty(ID_KEY, this.esNode.getNodeId().toString());
        summaryJson.addProperty(IP_KEY, this.esNode.getHostAddress().toString());
        return summaryJson.toString();
    }

    public static HeapSizeIncreaseAction fromSummary(@Nonnull String summary, @Nonnull AppContext appContext) {
        JsonObject jsonObject = JsonParser.parseString((String)summary).getAsJsonObject();
        NodeKey node = new NodeKey(new InstanceDetails.Id(jsonObject.get(ID_KEY).getAsString()), new InstanceDetails.Ip(jsonObject.get(IP_KEY).getAsString()));
        return new HeapSizeIncreaseAction(node, appContext);
    }
}

