/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.opendistro.elasticsearch.performanceanalyzer.decisionmaker.actions;

import com.amazon.opendistro.elasticsearch.performanceanalyzer.AppContext;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.decisionmaker.actions.ImpactVector;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.decisionmaker.actions.SuppressibleAction;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.rca.store.rca.cluster.NodeKey;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.annotations.SerializedName;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;

public class CacheClearAction
extends SuppressibleAction {
    public static final String NAME = "CacheClear";
    private final long coolOffPeriodInMillis;
    private final boolean canUpdate;
    private final List<NodeKey> impactedNodes;

    public CacheClearAction(AppContext appContext, long coolOffPeriodInMillis, boolean canUpdate) {
        super(appContext);
        this.coolOffPeriodInMillis = coolOffPeriodInMillis;
        this.canUpdate = canUpdate;
        this.impactedNodes = appContext.getDataNodeInstances().stream().map(ins -> new NodeKey(ins.getInstanceId(), ins.getInstanceIp())).collect(Collectors.toList());
    }

    @Override
    public String name() {
        return NAME;
    }

    @Override
    public boolean canUpdate() {
        return this.canUpdate;
    }

    @Override
    public long coolOffPeriodInMillis() {
        return this.coolOffPeriodInMillis;
    }

    @Override
    public List<NodeKey> impactedNodes() {
        return this.impactedNodes;
    }

    @Override
    public Map<NodeKey, ImpactVector> impact() {
        HashMap<NodeKey, ImpactVector> impactedMap = new HashMap<NodeKey, ImpactVector>();
        this.impactedNodes.forEach(node -> {
            ImpactVector impactVector = new ImpactVector();
            impactVector.decreasesPressure(ImpactVector.Dimension.HEAP);
            impactedMap.put((NodeKey)node, impactVector);
        });
        return impactedMap;
    }

    @Override
    public String summary() {
        Summary summary = new Summary(this.impactedNodes, this.coolOffPeriodInMillis, this.canUpdate);
        return summary.toJson();
    }

    public String toString() {
        return this.summary();
    }

    public static Builder newBuilder(AppContext appContext) {
        return new Builder(appContext);
    }

    public static class Summary {
        public static final String ID = "id";
        public static final String IP = "ip";
        public static final String COOL_OFF_PERIOD = "coolOffPeriodInMillis";
        public static final String CAN_UPDATE = "canUpdate";
        @SerializedName(value="id")
        private String[] id;
        @SerializedName(value="ip")
        private String[] ip;
        @SerializedName(value="coolOffPeriodInMillis")
        private long coolOffPeriodInMillis;
        @SerializedName(value="canUpdate")
        private boolean canUpdate;

        public Summary(List<NodeKey> impactedNodes, long coolOffPeriodInMillis, boolean canUpdate) {
            int sz = impactedNodes.size();
            this.id = new String[sz];
            this.ip = new String[sz];
            for (int i = 0; i < sz; ++i) {
                this.id[i] = impactedNodes.get(i).getNodeId().toString();
                this.ip[i] = impactedNodes.get(i).getHostAddress().toString();
            }
            this.coolOffPeriodInMillis = coolOffPeriodInMillis;
            this.canUpdate = canUpdate;
        }

        public String toJson() {
            Gson gson = new GsonBuilder().disableHtmlEscaping().create();
            return gson.toJson((Object)this);
        }

        public boolean getCanUpdate() {
            return this.canUpdate;
        }

        public long getCoolOffPeriodInMillis() {
            return this.coolOffPeriodInMillis;
        }
    }

    public static final class Builder {
        public static final long DEFAULT_COOL_OFF_PERIOD_IN_MILLIS = TimeUnit.MINUTES.toMillis(30L);
        public static final boolean DEFAULT_CAN_UPDATE = true;
        private final AppContext appContext;
        private boolean canUpdate;
        private long coolOffPeriodInMillis;

        private Builder(AppContext appContext) {
            this.appContext = appContext;
            this.coolOffPeriodInMillis = DEFAULT_COOL_OFF_PERIOD_IN_MILLIS;
            this.canUpdate = true;
        }

        public Builder coolOffPeriod(long coolOffPeriodInMillis) {
            this.coolOffPeriodInMillis = coolOffPeriodInMillis;
            return this;
        }

        public CacheClearAction build() {
            return new CacheClearAction(this.appContext, this.coolOffPeriodInMillis, this.canUpdate);
        }
    }
}

