/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.opendistro.elasticsearch.performanceanalyzer.core;

import java.io.File;
import java.security.AccessController;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.ParameterizedMessage;

public class Util {
    private static final Logger LOG = LogManager.getLogger(Util.class);
    public static final String METRICS_QUERY_URL = "/_opendistro/_performanceanalyzer/metrics";
    public static final String RCA_QUERY_URL = "/_opendistro/_performanceanalyzer/rca";
    public static final String ACTIONS_QUERY_URL = "/_opendistro/_performanceanalyzer/actions";
    public static final String ES_HOME = System.getProperty("es.path.home");
    public static final String PLUGIN_LOCATION = ES_HOME + File.separator + "plugins" + File.separator + "opendistro-performance-analyzer" + File.separator;
    public static final String READER_LOCATION = ES_HOME + File.separator + "performance-analyzer-rca" + File.separator;
    public static final String DATA_DIR = ES_HOME + File.separator + "data" + File.separator;

    public static void invokePrivileged(Runnable runner) {
        AccessController.doPrivileged(() -> {
            try {
                runner.run();
            }
            catch (Exception ex) {
                LOG.debug(() -> new ParameterizedMessage("Privileged Invocation failed {}", (Object)ex.toString()), (Throwable)ex);
            }
            return null;
        });
    }

    public static void invokePrivilegedAndLogError(Runnable runner) {
        AccessController.doPrivileged(() -> {
            try {
                runner.run();
            }
            catch (Exception ex) {
                LOG.error(() -> new ParameterizedMessage("Privileged Invocation failed {}", (Object)ex.toString()), (Throwable)ex);
            }
            return null;
        });
    }
}

