/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.opendistro.elasticsearch.performanceanalyzer.config.overrides;

import com.amazon.opendistro.elasticsearch.performanceanalyzer.config.overrides.ConfigOverrides;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.security.AccessController;

public class ConfigOverridesHelper {
    private static final ObjectMapper MAPPER = new ObjectMapper();

    public static synchronized String serialize(ConfigOverrides overrides) throws IOException {
        IOException[] exception = new IOException[1];
        String serializedOverrides = AccessController.doPrivileged(() -> {
            try {
                return MAPPER.writeValueAsString((Object)overrides);
            }
            catch (IOException e) {
                exception[0] = e;
                return "";
            }
        });
        if (serializedOverrides.isEmpty() && exception[0] != null) {
            throw exception[0];
        }
        return serializedOverrides;
    }

    public static synchronized ConfigOverrides deserialize(String overrides) throws IOException {
        IOException[] exception = new IOException[1];
        ConfigOverrides configOverrides = AccessController.doPrivileged(() -> {
            try {
                return (ConfigOverrides)MAPPER.readValue(overrides, ConfigOverrides.class);
            }
            catch (IOException ioe) {
                exception[0] = ioe;
                return null;
            }
        });
        if (configOverrides == null && exception[0] != null) {
            throw exception[0];
        }
        return configOverrides;
    }
}

