/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.opendistro.elasticsearch.performanceanalyzer.config;

import com.amazon.opendistro.elasticsearch.performanceanalyzer.ConfigStatus;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.config.ConfigFatalException;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.config.ConfigFileException;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.config.SettingsHelper;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.core.Util;
import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.util.Properties;
import javax.annotation.Nullable;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.ParameterizedMessage;

public class PluginSettings {
    private static final Logger LOG = LogManager.getLogger(PluginSettings.class);
    private static PluginSettings instance;
    public static final String CONFIG_FILES_PATH = "pa_config/";
    private static final String DEFAULT_CONFIG_FILE_PATH;
    private static final String METRICS_LOCATION_KEY = "metrics-location";
    private static final String METRICS_LOCATION_DEFAULT = "/dev/shm/performanceanalyzer/";
    private static final String DELETION_INTERVAL_KEY = "metrics-deletion-interval";
    private static final int DELETION_INTERVAL_DEFAULT = 1;
    private static final int WRITER_QUEUE_SIZE_DEFAULT = 100000;
    private static final int DELETION_INTERVAL_MIN = 1;
    private static final int DELETION_INTERVAL_MAX = 60;
    private static final String HTTPS_ENABLED = "https-enabled";
    private static final String WRITER_QUEUE_SIZE = "writer-queue-size";
    private static final String BATCH_METRICS_RETENTION_PERIOD_MINUTES = "batch-metrics-retention-period-minutes";
    private static final long BATCH_METRICS_RETENTION_PERIOD_MINUTES_DEFAULT = 7L;
    private static final long BATCH_METRICS_RETENTION_PERIOD_MINUTES_MIN = 1L;
    private static final long BATCH_METRICS_RETENTION_PERIOD_MINUTES_MAX = 60L;
    public static final String RPC_PORT_CONF_NAME = "rpc-port";
    public static final int RPC_DEFAULT_PORT = 9650;
    public static final String WEBSERVICE_PORT_CONF_NAME = "webservice-listener-port";
    public static final int WEBSERVICE_DEFAULT_PORT = 9600;
    public static final String DB_FILE_CLEANUP_CONF_NAME = "cleanup-metrics-db-files";
    private String metricsLocation = "/dev/shm/performanceanalyzer/";
    private int metricsDeletionInterval = 1;
    private int writerQueueSize = 100000;
    private boolean shouldCleanupMetricsDBFiles;
    private boolean httpsEnabled;
    private Properties settings;
    private final String configFilePath;
    private long batchMetricsRetentionPeriodMinutes = 7L;
    private int rpcPort = 9650;
    private int webServicePort = 9600;

    public String getMetricsLocation() {
        return this.metricsLocation;
    }

    public void setMetricsLocation(String metricsLocation) {
        this.metricsLocation = metricsLocation;
    }

    public int getMetricsDeletionInterval() {
        return this.metricsDeletionInterval * 60 * 1000;
    }

    public int getWriterQueueSize() {
        return this.writerQueueSize;
    }

    public long getBatchMetricsRetentionPeriodMinutes() {
        return this.batchMetricsRetentionPeriodMinutes;
    }

    public int getRpcPort() {
        return this.rpcPort;
    }

    public int getWebServicePort() {
        return this.webServicePort;
    }

    @VisibleForTesting
    public void setBatchMetricsRetentionPeriodMinutes(long batchMetricsRetentionPeriodMinutes) {
        this.batchMetricsRetentionPeriodMinutes = batchMetricsRetentionPeriodMinutes;
    }

    public String getSettingValue(String settingName) {
        return this.settings.getProperty(settingName);
    }

    public String getSettingValue(String settingName, String defaultValue) {
        return this.settings.getProperty(settingName, defaultValue);
    }

    private void loadHttpsEnabled() throws Exception {
        String httpsEnabledString = this.settings.getProperty(HTTPS_ENABLED, "False");
        if (httpsEnabledString == null) {
            this.httpsEnabled = false;
        }
        try {
            this.httpsEnabled = Boolean.parseBoolean(httpsEnabledString);
        }
        catch (Exception ex) {
            LOG.error("Unable to parse httpsEnabled property with value {}", (Object)httpsEnabledString);
            this.httpsEnabled = false;
        }
    }

    public boolean getHttpsEnabled() {
        return this.httpsEnabled;
    }

    @VisibleForTesting
    public void setHttpsEnabled(boolean httpsEnabled) {
        this.httpsEnabled = httpsEnabled;
    }

    @VisibleForTesting
    public void overrideProperty(String key, String value) {
        this.settings.setProperty(key, value);
    }

    @Nullable
    @VisibleForTesting
    public String getProperty(String key) {
        return this.settings.getProperty(key);
    }

    public boolean shouldCleanupMetricsDBFiles() {
        return this.shouldCleanupMetricsDBFiles;
    }

    @VisibleForTesting
    public void setShouldCleanupMetricsDBFiles(boolean shouldCleanupMetricsDBFiles) {
        this.shouldCleanupMetricsDBFiles = shouldCleanupMetricsDBFiles;
    }

    private PluginSettings(String cfPath) {
        this.configFilePath = cfPath == null || cfPath.isEmpty() ? DEFAULT_CONFIG_FILE_PATH : cfPath;
        this.settings = new Properties();
        try {
            this.settings = PluginSettings.getSettingsFromFile(this.configFilePath);
            this.loadMetricsDeletionIntervalFromConfig();
            this.loadMetricsLocationFromConfig();
            this.loadWriterQueueSizeFromConfig();
            this.loadHttpsEnabled();
            this.loadMetricsDBFilesCleanupEnabled();
            this.loadBatchMetricsRetentionPeriodMinutesFromConfig();
            this.loadPortsFromConfig();
        }
        catch (ConfigFileException e) {
            LOG.error("Loading config file {} failed with error: {}. Disabling plugin.", (Object)this.configFilePath, (Object)e.toString());
            ConfigStatus.INSTANCE.setConfigurationInvalid();
        }
        catch (ConfigFatalException e) {
            LOG.error("Having issue to load all config items. Disabling plugin.", (Throwable)e);
            ConfigStatus.INSTANCE.setConfigurationInvalid();
        }
        catch (Exception e) {
            LOG.error("Unexpected exception while initializing config. Disabling plugin.", (Throwable)e);
            ConfigStatus.INSTANCE.setConfigurationInvalid();
        }
        LOG.info("Config: metricsLocation: {}, metricsDeletionInterval: {}, httpsEnabled: {}, cleanup-metrics-db-files: {}, batch-metrics-retention-period-minutes: {}, rpc-port: {}, webservice-port {}", (Object)this.metricsLocation, (Object)this.metricsDeletionInterval, (Object)this.httpsEnabled, (Object)this.shouldCleanupMetricsDBFiles, (Object)this.batchMetricsRetentionPeriodMinutes, (Object)this.rpcPort, (Object)this.webServicePort);
    }

    public static PluginSettings instance() {
        return instance;
    }

    private static void createInstance() {
        String cfPath = System.getProperty("configFilePath");
        instance = new PluginSettings(cfPath);
    }

    private static Properties getSettingsFromFile(String filePath) throws ConfigFileException {
        try {
            return SettingsHelper.getSettings(filePath);
        }
        catch (Exception e) {
            throw new ConfigFileException(e);
        }
    }

    private void loadMetricsLocationFromConfig() throws ConfigFatalException {
        if (!this.settings.containsKey(METRICS_LOCATION_KEY)) {
            LOG.info("Cannot find metrics-location, using default value. {}", (Object)METRICS_LOCATION_DEFAULT);
        }
        this.metricsLocation = this.settings.getProperty(METRICS_LOCATION_KEY, METRICS_LOCATION_DEFAULT);
        PluginSettings.validateOrCreateDir(this.metricsLocation);
    }

    private static void validateOrCreateDir(String path) throws ConfigFatalException {
        boolean valid;
        File dict = new File(path);
        boolean dictCreated = true;
        if (!dict.exists()) {
            dictCreated = dict.mkdir();
            LOG.info("Trying to create directory {}.", (Object)path);
        }
        boolean bl = valid = dictCreated && dict.isDirectory() && dict.canWrite();
        if (!valid) {
            LOG.error("Invalid metrics location {}. Created: {} (Expect True), Directory: {} (Expect True), CanWrite: {} (Expect True)", (Object)path, (Object)dict.exists(), (Object)dict.isDirectory(), (Object)dict.canWrite());
            throw new ConfigFatalException("Having issue to use path: " + path);
        }
    }

    private void loadMetricsDeletionIntervalFromConfig() {
        if (!this.settings.containsKey(DELETION_INTERVAL_KEY)) {
            return;
        }
        try {
            int interval = Integer.parseInt(this.settings.getProperty(DELETION_INTERVAL_KEY));
            if (interval < 1 || interval > 60) {
                LOG.error("metrics-deletion-interval out of range. Value should in ({}-{}). Using default value {}.", (Object)1, (Object)60, (Object)this.metricsDeletionInterval);
                return;
            }
            this.metricsDeletionInterval = interval;
        }
        catch (NumberFormatException e) {
            LOG.error(() -> new ParameterizedMessage("Invalid metrics-deletion-interval. Using default value {}.", (Object)this.metricsDeletionInterval), (Throwable)e);
        }
    }

    private void loadWriterQueueSizeFromConfig() {
        if (!this.settings.containsKey(WRITER_QUEUE_SIZE)) {
            return;
        }
        try {
            int interval;
            this.writerQueueSize = interval = Integer.parseInt(this.settings.getProperty(WRITER_QUEUE_SIZE));
        }
        catch (NumberFormatException e) {
            LOG.error(() -> new ParameterizedMessage("Invalid writer-queue-size. Using default value {}.", (Object)this.writerQueueSize), (Throwable)e);
        }
    }

    private void loadMetricsDBFilesCleanupEnabled() {
        String cleanupEnabledString = this.settings.getProperty(DB_FILE_CLEANUP_CONF_NAME, "True");
        try {
            this.shouldCleanupMetricsDBFiles = Boolean.parseBoolean(cleanupEnabledString);
        }
        catch (Exception ex) {
            LOG.error("Unable to parse {} property with value {}. Only true/false expected.", (Object)DB_FILE_CLEANUP_CONF_NAME, (Object)cleanupEnabledString);
            this.shouldCleanupMetricsDBFiles = true;
        }
    }

    private void loadBatchMetricsRetentionPeriodMinutesFromConfig() {
        if (!this.settings.containsKey(BATCH_METRICS_RETENTION_PERIOD_MINUTES)) {
            return;
        }
        try {
            long parsedRetentionPeriod = Long.parseLong(this.settings.getProperty(BATCH_METRICS_RETENTION_PERIOD_MINUTES));
            if (parsedRetentionPeriod < 1L || parsedRetentionPeriod > 60L) {
                LOG.error("{} out of range. Value should be in range [{}, {}]. Using default value {}.", (Object)BATCH_METRICS_RETENTION_PERIOD_MINUTES, (Object)1L, (Object)60L, (Object)this.batchMetricsRetentionPeriodMinutes);
                return;
            }
            this.batchMetricsRetentionPeriodMinutes = parsedRetentionPeriod;
        }
        catch (NumberFormatException e) {
            LOG.error("Invalid batch-metrics-retention-period-minutes {}. Using default value {}.", (Object)this.settings.getProperty(BATCH_METRICS_RETENTION_PERIOD_MINUTES), (Object)this.batchMetricsRetentionPeriodMinutes);
        }
    }

    public void loadPortsFromConfig() {
        try {
            String rpcPortValue = this.settings.getProperty(RPC_PORT_CONF_NAME);
            String webServicePortValue = this.settings.getProperty(WEBSERVICE_PORT_CONF_NAME);
            if (rpcPortValue == null) {
                LOG.info("{} not configured; using default value: {}", (Object)RPC_PORT_CONF_NAME, (Object)9650);
                this.rpcPort = 9650;
            } else {
                this.rpcPort = Integer.parseInt(rpcPortValue);
            }
            if (webServicePortValue == null) {
                LOG.info("{} not configured; using default value: {}", (Object)WEBSERVICE_PORT_CONF_NAME, (Object)9600);
                this.webServicePort = 9600;
            } else {
                this.webServicePort = Integer.parseInt(webServicePortValue);
            }
        }
        catch (Exception ex) {
            LOG.error("Invalid Configuration: {} Using default value: {} AND Error: {}", (Object)RPC_PORT_CONF_NAME, (Object)9650, (Object)ex.toString());
            this.rpcPort = 9650;
            this.webServicePort = 9600;
        }
    }

    static {
        DEFAULT_CONFIG_FILE_PATH = Util.PLUGIN_LOCATION + "pa_config/performance-analyzer.properties";
        Util.invokePrivilegedAndLogError(PluginSettings::createInstance);
    }
}

