/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.opendistro.elasticsearch.performanceanalyzer.collectors;

import com.amazon.opendistro.elasticsearch.performanceanalyzer.collectors.PerformanceAnalyzerMetricsCollector;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ScheduledMetricCollectorsExecutor
extends Thread {
    private static final Logger LOG = LogManager.getLogger(ScheduledMetricCollectorsExecutor.class);
    private final int collectorThreadCount;
    private static final int DEFAULT_COLLECTOR_THREAD_COUNT = 5;
    private static final int COLLECTOR_THREAD_KEEPALIVE_SECS = 1000;
    private final boolean checkFeatureDisabledFlag;
    private boolean paEnabled = false;
    private int minTimeIntervalToSleep = Integer.MAX_VALUE;
    private Map<PerformanceAnalyzerMetricsCollector, Long> metricsCollectors = new HashMap<PerformanceAnalyzerMetricsCollector, Long>();
    private ThreadPoolExecutor metricsCollectorsTP = null;

    public ScheduledMetricCollectorsExecutor(int collectorThreadCount, boolean checkFeatureDisabledFlag) {
        this.collectorThreadCount = collectorThreadCount;
        this.checkFeatureDisabledFlag = checkFeatureDisabledFlag;
    }

    public ScheduledMetricCollectorsExecutor() {
        this(5, true);
    }

    public synchronized void setEnabled(boolean enabled) {
        this.paEnabled = enabled;
    }

    public synchronized boolean getEnabled() {
        return this.paEnabled;
    }

    public void addScheduledMetricCollector(PerformanceAnalyzerMetricsCollector task) {
        this.metricsCollectors.put(task, System.currentTimeMillis() + (long)task.getTimeInterval());
        if (task.getTimeInterval() < this.minTimeIntervalToSleep) {
            this.minTimeIntervalToSleep = task.getTimeInterval();
        }
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void run() {
        if (this.metricsCollectorsTP == null) {
            this.metricsCollectorsTP = new ThreadPoolExecutor(this.collectorThreadCount, this.collectorThreadCount, 1000L, TimeUnit.SECONDS, new ArrayBlockingQueue<Runnable>(this.metricsCollectors.size()));
        }
        prevStartTimestamp = System.currentTimeMillis();
        block2: while (true) {
            try {
                millisToSleep = (long)this.minTimeIntervalToSleep - System.currentTimeMillis() + prevStartTimestamp;
                if (millisToSleep > 0L) {
                    Thread.sleep(millisToSleep);
                }
            }
            catch (Exception ex) {
                ScheduledMetricCollectorsExecutor.LOG.error("Exception in Thread Sleep", (Throwable)ex);
            }
            prevStartTimestamp = System.currentTimeMillis();
            if (!this.getEnabled()) continue;
            currentTime = System.currentTimeMillis();
            var5_4 = this.metricsCollectors.entrySet().iterator();
            while (true) {
                if (var5_4.hasNext()) ** break;
                continue block2;
                entry = var5_4.next();
                if (entry.getValue() > currentTime) continue;
                collector = entry.getKey();
                this.metricsCollectors.put(collector, entry.getValue() + (long)collector.getTimeInterval());
                if (!collector.inProgress()) {
                    collector.setStartTime(currentTime);
                    this.metricsCollectorsTP.execute(collector);
                    continue;
                }
                ScheduledMetricCollectorsExecutor.LOG.info("Collector {} is still in progress, so skipping this Interval", (Object)collector.getCollectorName());
            }
            break;
        }
    }
}

