/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.opendistro.elasticsearch.performanceanalyzer.collectors;

import com.amazon.opendistro.elasticsearch.performanceanalyzer.collectors.StatExceptionCode;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.collectors.StatsCollector;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.core.Util;
import com.google.common.annotations.VisibleForTesting;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;

public abstract class PerformanceAnalyzerMetricsCollector
implements Runnable {
    private static final Logger LOG = LogManager.getLogger(PerformanceAnalyzerMetricsCollector.class);
    private int timeInterval;
    private long startTime;
    private String collectorName;
    protected StringBuilder value;
    private AtomicBoolean bInProgress = new AtomicBoolean(false);

    protected PerformanceAnalyzerMetricsCollector(int timeInterval, String collectorName) {
        this.timeInterval = timeInterval;
        this.collectorName = collectorName;
        this.value = new StringBuilder();
    }

    public int getTimeInterval() {
        return this.timeInterval;
    }

    public boolean inProgress() {
        return this.bInProgress.get();
    }

    public String getCollectorName() {
        return this.collectorName;
    }

    abstract void collectMetrics(long var1);

    public void setStartTime(long startTime) {
        this.startTime = startTime;
        this.bInProgress.set(true);
    }

    @Override
    public void run() {
        try {
            Util.invokePrivileged(() -> this.collectMetrics(this.startTime));
        }
        catch (Exception ex) {
            LOG.error("Error In Collect Metrics: {} with ExceptionCode: {}", new Supplier[]{() -> ex.toString(), () -> StatExceptionCode.OTHER_COLLECTION_ERROR.toString()});
            StatsCollector.instance().logException(StatExceptionCode.OTHER_COLLECTION_ERROR);
        }
        finally {
            this.bInProgress.set(false);
        }
    }

    @VisibleForTesting
    public StringBuilder getValue() {
        return this.value;
    }
}

