/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.opendistro.elasticsearch.performanceanalyzer.collectors;

import com.amazon.opendistro.elasticsearch.performanceanalyzer.OSMetricsGeneratorFactory;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.collectors.PerformanceAnalyzerMetricsCollector;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.jvm.ThreadList;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.metrics.AllMetrics;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.metrics.MetricsConfiguration;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.metrics.MetricsProcessor;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.metrics.PerformanceAnalyzerMetrics;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.metrics_generator.CPUPagingActivityGenerator;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.metrics_generator.DiskIOMetricsGenerator;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.metrics_generator.OSMetricsGenerator;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.metrics_generator.SchedMetricsGenerator;
import java.util.Map;

public class OSMetricsCollector
extends PerformanceAnalyzerMetricsCollector
implements MetricsProcessor {
    public static final int SAMPLING_TIME_INTERVAL = MetricsConfiguration.CONFIG_MAP.get(ThreadList.class).samplingInterval;
    private static final int KEYS_PATH_LENGTH = 1;
    private StringBuilder value = new StringBuilder();
    private OSMetricsGenerator osMetricsGenerator = OSMetricsGeneratorFactory.getInstance();

    public OSMetricsCollector() {
        super(SAMPLING_TIME_INTERVAL, "OSMetrics");
    }

    @Override
    public void collectMetrics(long startTime) {
        CPUPagingActivityGenerator threadCPUPagingActivityGenerator = this.osMetricsGenerator.getPagingActivityGenerator();
        threadCPUPagingActivityGenerator.addSample();
        SchedMetricsGenerator schedMetricsGenerator = this.osMetricsGenerator.getSchedMetricsGenerator();
        schedMetricsGenerator.addSample();
        Map<Long, ThreadList.ThreadState> threadStates = ThreadList.getNativeTidMap();
        DiskIOMetricsGenerator diskIOMetricsGenerator = this.osMetricsGenerator.getDiskIOMetricsGenerator();
        diskIOMetricsGenerator.addSample();
        for (String threadId : this.osMetricsGenerator.getAllThreadIds()) {
            ThreadList.ThreadState threadState;
            this.value.setLength(0);
            this.value.append(PerformanceAnalyzerMetrics.getCurrentTimeMetric()).append(PerformanceAnalyzerMetrics.sMetricNewLineDelimitor).append((Object)AllMetrics.OSMetrics.CPU_UTILIZATION).append(":").append(threadCPUPagingActivityGenerator.getCPUUtilization(threadId));
            if (threadCPUPagingActivityGenerator.hasPagingActivity(threadId)) {
                this.value.append(PerformanceAnalyzerMetrics.sMetricNewLineDelimitor).append((Object)AllMetrics.OSMetrics.PAGING_MAJ_FLT_RATE).append(":").append(threadCPUPagingActivityGenerator.getMajorFault(threadId));
                this.value.append(PerformanceAnalyzerMetrics.sMetricNewLineDelimitor).append((Object)AllMetrics.OSMetrics.PAGING_MIN_FLT_RATE).append(":").append(threadCPUPagingActivityGenerator.getMinorFault(threadId));
                this.value.append(PerformanceAnalyzerMetrics.sMetricNewLineDelimitor).append((Object)AllMetrics.OSMetrics.PAGING_RSS).append(":").append(threadCPUPagingActivityGenerator.getResidentSetSize(threadId));
            }
            if (schedMetricsGenerator.hasSchedMetrics(threadId)) {
                this.value.append(PerformanceAnalyzerMetrics.sMetricNewLineDelimitor).append((Object)AllMetrics.OSMetrics.SCHED_RUNTIME).append(":").append(schedMetricsGenerator.getAvgRuntime(threadId));
                this.value.append(PerformanceAnalyzerMetrics.sMetricNewLineDelimitor).append((Object)AllMetrics.OSMetrics.SCHED_WAITTIME).append(":").append(schedMetricsGenerator.getAvgWaittime(threadId));
                this.value.append(PerformanceAnalyzerMetrics.sMetricNewLineDelimitor).append((Object)AllMetrics.OSMetrics.SCHED_CTX_RATE).append(":").append(schedMetricsGenerator.getContextSwitchRate(threadId));
            }
            if ((threadState = threadStates.get(Long.valueOf(threadId))) != null) {
                this.value.append(PerformanceAnalyzerMetrics.sMetricNewLineDelimitor).append((Object)AllMetrics.OSMetrics.HEAP_ALLOC_RATE).append(":").append(threadState.heapAllocRate);
                this.value.append(PerformanceAnalyzerMetrics.sMetricNewLineDelimitor).append(MetaDataFields.threadName.toString()).append(":").append(threadState.threadName);
                this.value.append(PerformanceAnalyzerMetrics.sMetricNewLineDelimitor).append((Object)AllMetrics.OSMetrics.THREAD_BLOCKED_TIME).append(":").append(threadState.avgBlockedTime);
                this.value.append(PerformanceAnalyzerMetrics.sMetricNewLineDelimitor).append((Object)AllMetrics.OSMetrics.THREAD_BLOCKED_EVENT).append(":").append(threadState.blockedCount);
            }
            if (diskIOMetricsGenerator.hasDiskIOMetrics(threadId)) {
                this.value.append(PerformanceAnalyzerMetrics.sMetricNewLineDelimitor).append((Object)AllMetrics.OSMetrics.IO_READ_THROUGHPUT).append(":").append(diskIOMetricsGenerator.getAvgReadThroughputBps(threadId));
                this.value.append(PerformanceAnalyzerMetrics.sMetricNewLineDelimitor).append((Object)AllMetrics.OSMetrics.IO_WRITE_THROUGHPUT).append(":").append(diskIOMetricsGenerator.getAvgWriteThroughputBps(threadId));
                this.value.append(PerformanceAnalyzerMetrics.sMetricNewLineDelimitor).append((Object)AllMetrics.OSMetrics.IO_TOT_THROUGHPUT).append(":").append(diskIOMetricsGenerator.getAvgTotalThroughputBps(threadId));
                this.value.append(PerformanceAnalyzerMetrics.sMetricNewLineDelimitor).append((Object)AllMetrics.OSMetrics.IO_READ_SYSCALL_RATE).append(":").append(diskIOMetricsGenerator.getAvgReadSyscallRate(threadId));
                this.value.append(PerformanceAnalyzerMetrics.sMetricNewLineDelimitor).append((Object)AllMetrics.OSMetrics.IO_WRITE_SYSCALL_RATE).append(":").append(diskIOMetricsGenerator.getAvgWriteSyscallRate(threadId));
                this.value.append(PerformanceAnalyzerMetrics.sMetricNewLineDelimitor).append((Object)AllMetrics.OSMetrics.IO_TOTAL_SYSCALL_RATE).append(":").append(diskIOMetricsGenerator.getAvgTotalSyscallRate(threadId));
            }
            this.saveMetricValues(this.value.toString(), startTime, threadId);
        }
    }

    @Override
    public String getMetricsPath(long startTime, String ... keysPath) {
        if (keysPath.length != 1) {
            throw new RuntimeException("keys length should be 1");
        }
        return PerformanceAnalyzerMetrics.generatePath(startTime, "threads", keysPath[0], "os_metrics");
    }

    public static enum MetaDataFields {
        threadName;

    }
}

