/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.opendistro.elasticsearch.performanceanalyzer.collectors;

import com.amazon.opendistro.elasticsearch.performanceanalyzer.OSMetricsGeneratorFactory;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.collectors.PerformanceAnalyzerMetricsCollector;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.collectors.TCPStatus;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.metrics.MetricsConfiguration;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.metrics.MetricsProcessor;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.metrics.PerformanceAnalyzerMetrics;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.metrics_generator.OSMetricsGenerator;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.metrics_generator.TCPMetricsGenerator;
import java.util.HashMap;
import java.util.Map;

public class NetworkE2ECollector
extends PerformanceAnalyzerMetricsCollector
implements MetricsProcessor {
    private static final int sTimeInterval = MetricsConfiguration.CONFIG_MAP.get(NetworkE2ECollector.class).samplingInterval;

    public NetworkE2ECollector() {
        super(sTimeInterval, "NetworkE2ECollector");
    }

    @Override
    public void collectMetrics(long startTime) {
        OSMetricsGenerator generator = OSMetricsGeneratorFactory.getInstance();
        if (generator == null) {
            return;
        }
        TCPMetricsGenerator tcpMetricsGenerator = generator.getTCPMetricsGenerator();
        tcpMetricsGenerator.addSample();
        this.saveMetricValues(this.getMetrics(tcpMetricsGenerator), startTime, new String[0]);
    }

    @Override
    public String getMetricsPath(long startTime, String ... keysPath) {
        if (keysPath.length != 0) {
            throw new RuntimeException("keys length should be 0");
        }
        return PerformanceAnalyzerMetrics.generatePath(startTime, "tcp_metrics");
    }

    private Map<String, TCPStatus> getMetricsMap(TCPMetricsGenerator tcpMetricsGenerator) {
        HashMap<String, TCPStatus> map = new HashMap<String, TCPStatus>();
        for (String dest : tcpMetricsGenerator.getAllDestionationIps()) {
            TCPStatus tcpStatus = new TCPStatus(dest, tcpMetricsGenerator.getNumberOfFlows(dest), tcpMetricsGenerator.getTransmitQueueSize(dest), tcpMetricsGenerator.getReceiveQueueSize(dest), tcpMetricsGenerator.getCurrentLost(dest), tcpMetricsGenerator.getSendCongestionWindow(dest), tcpMetricsGenerator.getSlowStartThreshold(dest));
            map.put(dest, tcpStatus);
        }
        return map;
    }

    private String getMetrics(TCPMetricsGenerator tcpMetricsGenerator) {
        Map<String, TCPStatus> map = this.getMetricsMap(tcpMetricsGenerator);
        this.value.setLength(0);
        this.value.append(PerformanceAnalyzerMetrics.getJsonCurrentMilliSeconds()).append(PerformanceAnalyzerMetrics.sMetricNewLineDelimitor);
        for (TCPStatus tcpStatus : map.values()) {
            this.value.append(tcpStatus.serialize()).append(PerformanceAnalyzerMetrics.sMetricNewLineDelimitor);
        }
        return this.value.toString();
    }
}

