/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.opendistro.elasticsearch.performanceanalyzer.collectors;

import com.amazon.opendistro.elasticsearch.performanceanalyzer.OSMetricsGeneratorFactory;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.collectors.MountedPartitionMetrics;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.collectors.PerformanceAnalyzerMetricsCollector;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.metrics.MetricsConfiguration;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.metrics.MetricsProcessor;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.metrics.PerformanceAnalyzerMetrics;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.metrics_generator.MountedPartitionMetricsGenerator;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.metrics_generator.OSMetricsGenerator;
import java.util.Set;

public class MountedPartitionMetricsCollector
extends PerformanceAnalyzerMetricsCollector
implements MetricsProcessor {
    private static final int SAMPLING_TIME_INTERVAL = MetricsConfiguration.CONFIG_MAP.get(MountedPartitionMetricsCollector.class).samplingInterval;
    private static final int EXPECTED_KEYS_PATH_LENGTH = 0;

    public MountedPartitionMetricsCollector() {
        super(SAMPLING_TIME_INTERVAL, "MountedPartition");
    }

    @Override
    void collectMetrics(long startTime) {
        OSMetricsGenerator generator = OSMetricsGeneratorFactory.getInstance();
        if (generator == null) {
            return;
        }
        MountedPartitionMetricsGenerator mountedPartitionMetricsGenerator = generator.getMountedPartitionMetricsGenerator();
        mountedPartitionMetricsGenerator.addSample();
        this.saveMetricValues(this.getMetrics(mountedPartitionMetricsGenerator), startTime, new String[0]);
    }

    @Override
    public String getMetricsPath(long startTime, String ... keysPath) {
        if (keysPath != null && keysPath.length != 0) {
            throw new RuntimeException("keys length should be 0");
        }
        return PerformanceAnalyzerMetrics.generatePath(startTime, "mounted_part_space");
    }

    private String getMetrics(MountedPartitionMetricsGenerator mountedPartitionMetricsGenerator) {
        this.value.setLength(0);
        this.value.append(PerformanceAnalyzerMetrics.getJsonCurrentMilliSeconds()).append(PerformanceAnalyzerMetrics.sMetricNewLineDelimitor);
        Set<String> mountPoints = mountedPartitionMetricsGenerator.getAllMountPoints();
        for (String mountPoint : mountPoints) {
            this.value.append(new MountedPartitionMetrics(mountedPartitionMetricsGenerator.getDevicePartition(mountPoint), mountPoint, mountedPartitionMetricsGenerator.getTotalSpace(mountPoint), mountedPartitionMetricsGenerator.getFreeSpace(mountPoint), mountedPartitionMetricsGenerator.getUsableFreeSpace(mountPoint)).serialize()).append(PerformanceAnalyzerMetrics.sMetricNewLineDelimitor);
        }
        return this.value.toString();
    }
}

