/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.opendistro.elasticsearch.performanceanalyzer.collectors;

import com.amazon.opendistro.elasticsearch.performanceanalyzer.collectors.PerformanceAnalyzerMetricsCollector;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.config.PluginSettings;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.metrics.MetricsConfiguration;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.metrics.PerformanceAnalyzerMetrics;
import java.io.File;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MetricsPurgeActivity
extends PerformanceAnalyzerMetricsCollector {
    private static final Logger LOG = LogManager.getLogger(MetricsPurgeActivity.class);
    private static int purgeInterval = MetricsConfiguration.CONFIG_MAP.get(MetricsPurgeActivity.class).deletionInterval;

    public MetricsPurgeActivity() {
        super(MetricsConfiguration.CONFIG_MAP.get(MetricsPurgeActivity.class).samplingInterval, "MetricsPurgeActivity");
    }

    @Override
    public void collectMetrics(long startTime) {
        this.deleteEventLogFiles(startTime);
    }

    private void deleteEventLogFiles(long referenceTime) {
        LOG.debug("Starting to delete old writer files");
        File root = new File(PluginSettings.instance().getMetricsLocation());
        String[] children = root.list();
        if (children == null) {
            return;
        }
        int filesDeletedCount = 0;
        for (String child : children) {
            File fileToDelete = new File(root, child);
            if (fileToDelete.lastModified() >= PerformanceAnalyzerMetrics.getTimeInterval(referenceTime - (long)purgeInterval)) continue;
            PerformanceAnalyzerMetrics.removeMetrics(fileToDelete);
            ++filesDeletedCount;
        }
        LOG.debug("'{}' Old writer files cleaned up.", (Object)filesDeletedCount);
    }
}

