/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.opendistro.elasticsearch.performanceanalyzer.collectors;

import com.amazon.opendistro.elasticsearch.performanceanalyzer.collectors.MetricStatus;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.collectors.PerformanceAnalyzerMetricsCollector;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.jvm.GCMetrics;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.jvm.HeapMetrics;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.metrics.AllMetrics;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.metrics.MetricsConfiguration;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.metrics.MetricsProcessor;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.metrics.PerformanceAnalyzerMetrics;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.annotations.VisibleForTesting;
import java.lang.management.MemoryUsage;
import java.util.Map;
import java.util.function.Supplier;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class HeapMetricsCollector
extends PerformanceAnalyzerMetricsCollector
implements MetricsProcessor {
    private static final Logger LOG = LogManager.getLogger(HeapMetricsCollector.class);
    public static final int SAMPLING_TIME_INTERVAL = MetricsConfiguration.CONFIG_MAP.get(HeapMetricsCollector.class).samplingInterval;
    private static final int KEYS_PATH_LENGTH = 0;

    public HeapMetricsCollector() {
        super(SAMPLING_TIME_INTERVAL, "HeapMetrics");
    }

    @Override
    public void collectMetrics(long startTime) {
        GCMetrics.runGCMetrics();
        this.value.setLength(0);
        this.value.append(PerformanceAnalyzerMetrics.getJsonCurrentMilliSeconds()).append(PerformanceAnalyzerMetrics.sMetricNewLineDelimitor);
        this.value.append(new HeapStatus(AllMetrics.GCType.TOT_YOUNG_GC.toString(), GCMetrics.getTotYoungGCCollectionCount(), GCMetrics.getTotYoungGCCollectionTime()).serialize()).append(PerformanceAnalyzerMetrics.sMetricNewLineDelimitor);
        this.value.append(new HeapStatus(AllMetrics.GCType.TOT_FULL_GC.toString(), GCMetrics.getTotFullGCCollectionCount(), GCMetrics.getTotFullGCCollectionTime()).serialize()).append(PerformanceAnalyzerMetrics.sMetricNewLineDelimitor);
        for (Map.Entry<String, Supplier<MemoryUsage>> entry : HeapMetrics.getMemoryUsageSuppliers().entrySet()) {
            MemoryUsage memoryUsage = entry.getValue().get();
            this.value.append(new HeapStatus(entry.getKey(), memoryUsage.getCommitted(), memoryUsage.getInit(), memoryUsage.getMax(), memoryUsage.getUsed()).serialize()).append(PerformanceAnalyzerMetrics.sMetricNewLineDelimitor);
        }
        this.saveMetricValues(this.value.toString(), startTime, new String[0]);
    }

    @Override
    public String getMetricsPath(long startTime, String ... keysPath) {
        if (keysPath.length != 0) {
            throw new RuntimeException("keys length should be 0");
        }
        return PerformanceAnalyzerMetrics.generatePath(startTime, "heap_metrics");
    }

    public static class HeapStatus
    extends MetricStatus {
        private String type;
        @VisibleForTesting
        static final long UNDEFINED = -2L;
        private long collectionCount = -2L;
        private long collectionTime = -2L;
        private long committed = -2L;
        private long init = -2L;
        private long max = -2L;
        private long used = -2L;

        public HeapStatus() {
        }

        public HeapStatus(String type, long collectionCount, long collectionTime) {
            this.type = type;
            this.collectionCount = collectionCount;
            this.collectionTime = collectionTime;
        }

        public HeapStatus(String type, long committed, long init, long max, long used) {
            this.type = type;
            this.committed = committed;
            this.init = init;
            this.max = max;
            this.used = used;
        }

        @JsonProperty(value="MemType")
        public String getType() {
            return this.type;
        }

        @JsonProperty(value="GC_Collection_Event")
        public long getCollectionCount() {
            return this.collectionCount;
        }

        @JsonProperty(value="GC_Collection_Time")
        public long getCollectionTime() {
            return this.collectionTime;
        }

        @JsonProperty(value="Heap_Committed")
        public long getCommitted() {
            return this.committed;
        }

        @JsonProperty(value="Heap_Init")
        public long getInit() {
            return this.init;
        }

        @JsonProperty(value="Heap_Max")
        public long getMax() {
            return this.max;
        }

        @JsonProperty(value="Heap_Used")
        public long getUsed() {
            return this.used;
        }
    }
}

