/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.opendistro.elasticsearch.performanceanalyzer.collections;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.Iterator;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import javax.annotation.Nonnull;

public class TimeExpiringSet<E>
implements Iterable<E> {
    private Cache<E, E> cache;

    public TimeExpiringSet(long ttl, TimeUnit unit) {
        this.cache = CacheBuilder.newBuilder().expireAfterWrite(ttl, unit).build();
    }

    public boolean contains(E e) {
        return this.cache.getIfPresent(e) != null;
    }

    public long size() {
        return this.cache.size();
    }

    @Override
    @Nonnull
    public Iterator<E> iterator() {
        return this.cache.asMap().keySet().iterator();
    }

    public void add(E e) {
        this.cache.put(e, e);
    }

    @Override
    public void forEach(Consumer<? super E> action) {
        this.iterator().forEachRemaining(action);
    }
}

