/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.opendistro.elasticsearch.performanceanalyzer;

import com.amazon.opendistro.elasticsearch.performanceanalyzer.AppContext;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.ClientServers;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.ConfigStatus;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.PerformanceAnalyzerThreads;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.PerformanceAnalyzerWebServer;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.collectors.ScheduledMetricCollectorsExecutor;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.collectors.StatExceptionCode;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.collectors.StatsCollector;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.config.PluginSettings;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.config.TroubleshootingConfig;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.core.Util;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.metrics.MetricsConfiguration;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.metrics.MetricsRestUtil;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.metrics.handler.MetricsServerHandler;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.net.GRPCConnectionManager;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.net.NetClient;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.net.NetServer;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.rca.RcaController;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.rca.framework.core.MetricsDBProvider;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.rca.framework.metrics.ExceptionsAndErrors;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.rca.framework.metrics.JvmMetrics;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.rca.framework.metrics.RcaGraphMetrics;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.rca.framework.metrics.RcaRuntimeMetrics;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.rca.framework.metrics.RcaVerticesMetrics;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.rca.framework.metrics.ReaderMetrics;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.rca.framework.metrics.WriterMetrics;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.rca.framework.sys.AllJvmSamplers;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.rca.listener.MisbehavingGraphOperateMethodListener;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.rca.samplers.BatchMetricsEnabledSampler;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.rca.samplers.MetricsDBFileSampler;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.rca.samplers.RcaStateSamplers;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.rca.stats.RcaStatsReporter;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.rca.stats.collectors.SampleAggregator;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.rca.stats.emitters.ISampler;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.rca.stats.emitters.PeriodicSamplers;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.rca.stats.listeners.IListener;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.rca.stats.measurements.MeasurementSet;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.reader.ReaderMetricsProcessor;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.rest.QueryBatchRequestHandler;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.rest.QueryMetricsRequestHandler;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.threads.ThreadProvider;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.threads.exceptions.PAThreadException;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.sun.net.httpserver.HttpServer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PerformanceAnalyzerApp {
    private static final int EXCEPTION_QUEUE_LENGTH = 1;
    public static final String QUERY_URL = "/_opendistro/_performanceanalyzer/metrics";
    public static final String BATCH_METRICS_URL = "/_opendistro/_performanceanalyzer/batch";
    private static final Logger LOG = LogManager.getLogger(PerformanceAnalyzerApp.class);
    private static final ScheduledMetricCollectorsExecutor METRIC_COLLECTOR_EXECUTOR = new ScheduledMetricCollectorsExecutor(1, false);
    private static final ScheduledExecutorService netOperationsExecutor = Executors.newScheduledThreadPool(2, new ThreadFactoryBuilder().setNameFormat("network-thread-%d").build());
    private static RcaController rcaController = null;
    private static final ThreadProvider THREAD_PROVIDER = new ThreadProvider();
    public static final SampleAggregator RCA_GRAPH_METRICS_AGGREGATOR = new SampleAggregator(RcaGraphMetrics.values());
    public static final SampleAggregator RCA_RUNTIME_METRICS_AGGREGATOR = new SampleAggregator(RcaRuntimeMetrics.values());
    public static final SampleAggregator RCA_VERTICES_METRICS_AGGREGATOR = new SampleAggregator(RcaVerticesMetrics.values());
    public static final SampleAggregator READER_METRICS_AGGREGATOR = new SampleAggregator(ReaderMetrics.values());
    public static final SampleAggregator WRITER_METRICS_AGGREGATOR = new SampleAggregator(WriterMetrics.values());
    private static final IListener MISBEHAVING_NODES_LISTENER = new MisbehavingGraphOperateMethodListener();
    public static final SampleAggregator ERRORS_AND_EXCEPTIONS_AGGREGATOR = new SampleAggregator(MISBEHAVING_NODES_LISTENER.getMeasurementsListenedTo(), MISBEHAVING_NODES_LISTENER, ExceptionsAndErrors.values());
    public static final SampleAggregator PERIODIC_SAMPLE_AGGREGATOR = new SampleAggregator(PerformanceAnalyzerApp.getPeriodicMeasurementSets());
    public static final RcaStatsReporter RCA_STATS_REPORTER = new RcaStatsReporter(Arrays.asList(RCA_GRAPH_METRICS_AGGREGATOR, RCA_RUNTIME_METRICS_AGGREGATOR, RCA_VERTICES_METRICS_AGGREGATOR, READER_METRICS_AGGREGATOR, WRITER_METRICS_AGGREGATOR, ERRORS_AND_EXCEPTIONS_AGGREGATOR, PERIODIC_SAMPLE_AGGREGATOR));
    public static PeriodicSamplers PERIODIC_SAMPLERS;
    public static final BlockingQueue<PAThreadException> exceptionQueue;

    public static void main(String[] args) {
        StatsCollector.STATS_TYPE = "agent-stats-metadata";
        PluginSettings settings = PluginSettings.instance();
        if (ConfigStatus.INSTANCE.haveValidConfig()) {
            AppContext appContext = new AppContext();
            PERIODIC_SAMPLERS = new PeriodicSamplers(PERIODIC_SAMPLE_AGGREGATOR, PerformanceAnalyzerApp.getAllSamplers(appContext), MetricsConfiguration.CONFIG_MAP.get(StatsCollector.class).samplingInterval / 2, TimeUnit.MILLISECONDS);
            METRIC_COLLECTOR_EXECUTOR.addScheduledMetricCollector(StatsCollector.instance());
            StatsCollector.instance().addDefaultExceptionCode(StatExceptionCode.READER_RESTART_PROCESSING);
            METRIC_COLLECTOR_EXECUTOR.setEnabled(true);
            METRIC_COLLECTOR_EXECUTOR.start();
            GRPCConnectionManager connectionManager = new GRPCConnectionManager(settings.getHttpsEnabled());
            ClientServers clientServers = PerformanceAnalyzerApp.createClientServers(connectionManager, appContext);
            PerformanceAnalyzerApp.startErrorHandlingThread(THREAD_PROVIDER, exceptionQueue);
            PerformanceAnalyzerApp.startReaderThread(appContext, THREAD_PROVIDER);
            PerformanceAnalyzerApp.startGrpcServerThread(clientServers.getNetServer(), THREAD_PROVIDER);
            PerformanceAnalyzerApp.startWebServerThread(clientServers.getHttpServer(), THREAD_PROVIDER);
            PerformanceAnalyzerApp.startRcaTopLevelThread(clientServers, connectionManager, appContext, THREAD_PROVIDER);
        } else {
            LOG.error("Performance analyzer app stopped due to invalid config status.");
            StatsCollector.instance().logException(StatExceptionCode.READER_THREAD_STOPPED);
        }
    }

    private static void startRcaTopLevelThread(ClientServers clientServers, GRPCConnectionManager connectionManager, AppContext appContext, ThreadProvider threadProvider) {
        rcaController = new RcaController(threadProvider, netOperationsExecutor, connectionManager, clientServers, Util.DATA_DIR, 5000L, 60000L, appContext, new MetricsDBProvider());
        PerformanceAnalyzerApp.startRcaTopLevelThread(rcaController, threadProvider);
    }

    public static Thread startRcaTopLevelThread(RcaController rcaController1, ThreadProvider threadProvider) {
        return PerformanceAnalyzerApp.startRcaTopLevelThread(rcaController1, threadProvider, "");
    }

    public static Thread startRcaTopLevelThread(RcaController rcaController1, ThreadProvider threadProvider, String nodeName) {
        Thread rcaControllerThread = threadProvider.createThreadForRunnable(() -> rcaController1.run(), PerformanceAnalyzerThreads.RCA_CONTROLLER, nodeName);
        rcaControllerThread.start();
        return rcaControllerThread;
    }

    public static Thread startErrorHandlingThread(ThreadProvider threadProvider, BlockingQueue<PAThreadException> errorQueue) {
        Thread errorHandlingThread = threadProvider.createThreadForRunnable(() -> {
            try {
                while (true) {
                    PAThreadException exception = (PAThreadException)errorQueue.take();
                    PerformanceAnalyzerApp.handle(exception);
                }
            }
            catch (InterruptedException e) {
                LOG.error("Exception handling thread interrupted. Reason: {}", (Object)e.getMessage(), (Object)e);
                return;
            }
        }, PerformanceAnalyzerThreads.PA_ERROR_HANDLER);
        errorHandlingThread.start();
        return errorHandlingThread;
    }

    private static void handle(PAThreadException exception) {
        LOG.error("Thread: {} ran into an uncaught exception: {}", (Object)exception.getPaThreadName(), (Object)exception.getInnerThrowable(), (Object)exception);
        StatsCollector.instance().logException(exception.getExceptionCode());
    }

    public static Thread startWebServerThread(HttpServer server, ThreadProvider threadProvider) {
        Thread webServerThread = threadProvider.createThreadForRunnable(server::start, PerformanceAnalyzerThreads.WEB_SERVER);
        webServerThread.setDaemon(true);
        webServerThread.start();
        return webServerThread;
    }

    public static Thread startGrpcServerThread(NetServer server, ThreadProvider threadProvider) {
        Thread grpcServerThread = threadProvider.createThreadForRunnable(server, PerformanceAnalyzerThreads.GRPC_SERVER);
        grpcServerThread.setDaemon(true);
        grpcServerThread.start();
        return grpcServerThread;
    }

    private static void startReaderThread(AppContext appContext, ThreadProvider threadProvider) {
        PluginSettings settings = PluginSettings.instance();
        Thread readerThread = threadProvider.createThreadForRunnable(() -> {
            while (true) {
                try {
                    while (true) {
                        ReaderMetricsProcessor mp = new ReaderMetricsProcessor(settings.getMetricsLocation(), true, appContext);
                        ReaderMetricsProcessor.setCurrentInstance(mp);
                        mp.run();
                    }
                }
                catch (Throwable e) {
                    if (!TroubleshootingConfig.getEnableDevAssert()) {
                        LOG.error("Error in ReaderMetricsProcessor...restarting, ExceptionCode: {}", (Object)StatExceptionCode.READER_RESTART_PROCESSING.toString());
                        StatsCollector.instance().logException(StatExceptionCode.READER_RESTART_PROCESSING);
                        continue;
                    }
                    return;
                }
                break;
            }
        }, PerformanceAnalyzerThreads.PA_READER);
        readerThread.start();
    }

    public static ClientServers createClientServers(GRPCConnectionManager connectionManager, AppContext appContext) {
        PluginSettings settings = PluginSettings.instance();
        boolean useHttps = settings.getHttpsEnabled();
        return PerformanceAnalyzerApp.createClientServers(connectionManager, settings.getRpcPort(), new MetricsServerHandler(), new MetricsRestUtil(), useHttps, settings.getWebServicePort(), settings.getSettingValue("webservice-bind-host"), appContext);
    }

    public static ClientServers createClientServers(GRPCConnectionManager connectionManager, int rpcPort, MetricsServerHandler metricsServerHandler, MetricsRestUtil metricsRestUtil, boolean useHttps, int webServerPort, String hostFromSetting, AppContext appContext) {
        NetServer netServer = new NetServer(rpcPort, 1, useHttps);
        NetClient netClient = new NetClient(connectionManager);
        if (metricsServerHandler != null) {
            netServer.setMetricsHandler(metricsServerHandler);
        }
        HttpServer httpServer = PerformanceAnalyzerWebServer.createInternalServer(webServerPort, hostFromSetting, useHttps);
        if (metricsRestUtil != null) {
            httpServer.createContext(QUERY_URL, new QueryMetricsRequestHandler(netClient, metricsRestUtil, appContext));
            httpServer.createContext(BATCH_METRICS_URL, new QueryBatchRequestHandler(netClient, metricsRestUtil));
        }
        return new ClientServers(httpServer, netServer, netClient);
    }

    public static List<ISampler> getAllSamplers(AppContext appContext) {
        ArrayList<ISampler> allSamplers = new ArrayList<ISampler>();
        allSamplers.addAll(AllJvmSamplers.getJvmSamplers());
        allSamplers.add(RcaStateSamplers.getRcaEnabledSampler(appContext));
        allSamplers.add(new BatchMetricsEnabledSampler(appContext));
        allSamplers.add(new MetricsDBFileSampler(appContext));
        return allSamplers;
    }

    private static MeasurementSet[] getPeriodicMeasurementSets() {
        ArrayList<Enum> measurementSets = new ArrayList<Enum>();
        measurementSets.addAll(Arrays.asList(JvmMetrics.values()));
        measurementSets.add(RcaRuntimeMetrics.RCA_ENABLED);
        measurementSets.add(ReaderMetrics.BATCH_METRICS_ENABLED);
        measurementSets.add(ReaderMetrics.METRICSDB_NUM_FILES);
        measurementSets.add(ReaderMetrics.METRICSDB_SIZE_FILES);
        measurementSets.add(ReaderMetrics.METRICSDB_NUM_UNCOMPRESSED_FILES);
        measurementSets.add(ReaderMetrics.METRICSDB_SIZE_UNCOMPRESSED_FILES);
        return measurementSets.toArray(new MeasurementSet[0]);
    }

    public static RcaController getRcaController() {
        return rcaController;
    }

    @VisibleForTesting
    public static void setRcaController(RcaController rcaController) {
        PerformanceAnalyzerApp.rcaController = rcaController;
    }

    static {
        exceptionQueue = new ArrayBlockingQueue<PAThreadException>(1);
    }
}

